/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

abstract class Timed<T>
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.Timed");
    private static final Map<Timed, Boolean> ourReferences = Collections.synchronizedMap(new WeakHashMap());
    protected static final int SERVICE_DELAY = 60;
    private int myLastCheckedAccessCount;
    int myAccessCount;
    protected T myT;
    private boolean myPolled;

    protected Timed(@Nullable Disposable parentDisposable) {
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, this);
        }
    }

    @Override
    public synchronized void dispose() {
        T t = this.myT;
        this.myT = null;
        if (t instanceof Disposable) {
            Disposer.dispose((Disposable)t);
        }
        this.remove();
    }

    protected final void poll() {
        if (!this.myPolled) {
            ourReferences.put(this, Boolean.TRUE);
            this.myPolled = true;
        }
    }

    protected final void remove() {
        ourReferences.remove(this);
        this.myPolled = false;
    }

    protected synchronized boolean isLocked() {
        return false;
    }

    protected synchronized boolean checkLocked() {
        return this.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeTimed() {
        Timed[] references;
        for (Timed timed : references = ourReferences.keySet().toArray(new Timed[0])) {
            if (timed == null) continue;
            Timed timed2 = timed;
            synchronized (timed2) {
                if (timed.myLastCheckedAccessCount == timed.myAccessCount && !timed.checkLocked()) {
                    Disposer.dispose(timed);
                } else {
                    timed.myLastCheckedAccessCount = timed.myAccessCount;
                }
            }
        }
    }

    static {
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    Timed.disposeTimed();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }
}

