/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsFile;
import com.intellij.cvsSupport2.cvsBrowser.CvsModule;
import com.intellij.cvsSupport2.cvsBrowser.LoadingNode;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeNodeComparator
implements Comparator<DefaultMutableTreeNode> {
    public static final TreeNodeComparator INSTANCE = new TreeNodeComparator();

    private TreeNodeComparator() {
    }

    @Override
    public int compare(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
        if (!SystemInfo.isMac) {
            if (node1 instanceof CvsModule) {
                if (!(node2 instanceof CvsModule)) {
                    return -1;
                }
            } else {
                if (node2 instanceof CvsModule) {
                    return 1;
                }
                if (node1 instanceof CvsFile) {
                    if (!(node2 instanceof CvsFile)) {
                        return 1;
                    }
                } else if (node2 instanceof CvsFile) {
                    return -1;
                }
            }
            if (!(node1 instanceof CvsElement)) {
                return 1;
            }
            if (!(node2 instanceof CvsElement)) {
                return -1;
            }
        }
        if (node1 instanceof LoadingNode) {
            return 1;
        }
        if (node2 instanceof LoadingNode) {
            return -1;
        }
        String name1 = ((CvsElement)node1).getName();
        String name2 = ((CvsElement)node2).getName();
        return StringUtil.naturalCompare((String)name1, (String)name2);
    }
}

