/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.ObjectUtils;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.ui.branch.GitBranchPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchWidget
extends DvcsStatusWidget<GitRepository> {
    private final GitVcsSettings mySettings;

    public GitBranchWidget(@NotNull Project project) {
        if (project == null) {
            GitBranchWidget.$$$reportNull$$$0(0);
        }
        super(project, "Git");
        this.mySettings = GitVcsSettings.getInstance(project);
    }

    public StatusBarWidget copy() {
        return new GitBranchWidget((Project)ObjectUtils.assertNotNull((Object)this.getProject()));
    }

    @Nullable
    protected GitRepository guessCurrentRepository(@NotNull Project project) {
        if (project == null) {
            GitBranchWidget.$$$reportNull$$$0(1);
        }
        return (GitRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)project, (AbstractRepositoryManager)GitUtil.getRepositoryManager(project), (String)this.mySettings.getRecentRootPath());
    }

    @NotNull
    protected String getFullBranchName(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchWidget.$$$reportNull$$$0(2);
        }
        String string = GitBranchUtil.getDisplayableBranchText(repository);
        if (string == null) {
            GitBranchWidget.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        if (project == null) {
            GitBranchWidget.$$$reportNull$$$0(4);
        }
        return !GitUtil.justOneGitRepository(project);
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull GitRepository repository) {
        if (project == null) {
            GitBranchWidget.$$$reportNull$$$0(5);
        }
        if (repository == null) {
            GitBranchWidget.$$$reportNull$$$0(6);
        }
        ListPopup listPopup = GitBranchPopup.getInstance(project, repository).asListPopup();
        if (listPopup == null) {
            GitBranchWidget.$$$reportNull$$$0(7);
        }
        return listPopup;
    }

    protected void subscribeToRepoChangeEvents(@NotNull Project project) {
        if (project == null) {
            GitBranchWidget.$$$reportNull$$$0(8);
        }
        project.getMessageBus().connect().subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                if (repository == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.debug("repository changed");
                GitBranchWidget.this.updateLater();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/ui/branch/GitBranchWidget$1", "repositoryChanged"));
            }
        });
    }

    protected void rememberRecentRoot(@NotNull String path) {
        if (path == null) {
            GitBranchWidget.$$$reportNull$$$0(9);
        }
        this.mySettings.setRecentRoot(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitBranchWidget";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitBranchWidget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullBranchName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "guessCurrentRepository";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFullBranchName";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMultiRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "subscribeToRepoChangeEvents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rememberRecentRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

