/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.MysqlIntermediateFacade;

public class MysqlIntermediateSession
extends JdbcIntermediateSession {
    public MysqlIntermediateSession(@Nullable JdbcIntermediateFacade facade, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull Connection connection, boolean ownConnection) {
        super(facade, exceptionRecognizer, connection, ownConnection);
    }

    @Override
    @NotNull
    PreparedStatement prepareSimpleStatement(@NotNull String statementText) throws SQLException {
        return this.getConnection().prepareStatement(statementText, 1003, 1007);
    }

    @Override
    protected void tuneStatementWithFetchSize(PreparedStatement stmt, int packLimit) throws SQLException {
        boolean rowByRow;
        switch (this.getFetchStrategy()) {
            case 1: {
                rowByRow = true;
                break;
            }
            case 0: {
                rowByRow = packLimit > 0;
                break;
            }
            default: {
                rowByRow = false;
            }
        }
        if (rowByRow) {
            stmt.setFetchSize(Integer.MIN_VALUE);
        }
    }

    @Override
    protected void tuneResultSetWithFetchSize(@NotNull ResultSet rset, int packLimit) {
    }

    public byte getFetchStrategy() {
        MysqlIntermediateFacade facade = this.myFacade instanceof MysqlIntermediateFacade ? (MysqlIntermediateFacade)this.myFacade : null;
        return facade != null ? facade.getFetchStrategy() : (byte)0;
    }
}

