/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffApplicationBase
extends ApplicationStarterEx {
    protected static final String NULL_PATH = "/dev/null";
    protected static final Logger LOG = Logger.getInstance(DiffApplicationBase.class);

    protected abstract boolean checkArguments(@NotNull String[] var1);

    @NotNull
    protected abstract String getUsageMessage();

    protected abstract void processCommand(@NotNull String[] var1, @Nullable String var2) throws Exception;

    public boolean isHeadless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExternalCommandLine(@NotNull String[] args, @Nullable String currentDirectory) {
        if (args == null) {
            DiffApplicationBase.$$$reportNull$$$0(0);
        }
        if (!this.checkArguments(args)) {
            Messages.showMessageDialog((String)this.getUsageMessage(), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getInformationIcon());
            return;
        }
        try {
            this.processCommand(args, currentDirectory);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)String.format("Error showing %s: %s", this.getCommandName(), e.getMessage()), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getErrorIcon());
        }
        finally {
            DiffApplicationBase.saveAll();
        }
    }

    private static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    public void premain(String[] args) {
        if (!this.checkArguments(args)) {
            System.out.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    public void main(String[] args) {
        try {
            this.processCommand(args, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
        finally {
            DiffApplicationBase.saveAll();
        }
        System.exit(0);
    }

    @NotNull
    public static List<VirtualFile> findFiles(@NotNull List<String> filePaths, @Nullable String currentDirectory) throws Exception {
        if (filePaths == null) {
            DiffApplicationBase.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (String path : filePaths) {
            if (NULL_PATH.equals(path)) {
                files2.add(null);
                continue;
            }
            VirtualFile virtualFile = DiffApplicationBase.findFile(path, currentDirectory);
            if (virtualFile == null) {
                throw new Exception("Can't find file: " + path);
            }
            files2.add(virtualFile);
        }
        DiffApplicationBase.refreshAndEnsureFilesValid(ContainerUtil.skipNulls(files2));
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            DiffApplicationBase.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void refreshAndEnsureFilesValid(@NotNull List<? extends VirtualFile> files2) throws Exception {
        if (files2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(3);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(files2));
        for (VirtualFile virtualFile : files2) {
            if (virtualFile.isValid()) continue;
            throw new Exception("Can't find file: " + virtualFile.getPresentableUrl());
        }
    }

    @Nullable
    public static VirtualFile findFile(@NotNull String path, @Nullable String currentDirectory) {
        if (path == null) {
            DiffApplicationBase.$$$reportNull$$$0(4);
        }
        File file2 = DiffApplicationBase.getFile(path, currentDirectory);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (virtualFile == null) {
            LOG.warn(String.format("Can't find file: current directory - %s; path - %s", currentDirectory, path));
        }
        return virtualFile;
    }

    @NotNull
    public static File getFile(@NotNull String path, @Nullable String currentDirectory) {
        File file2;
        if (path == null) {
            DiffApplicationBase.$$$reportNull$$$0(5);
        }
        if (!(file2 = new File(path)).isAbsolute() && currentDirectory != null) {
            file2 = new File(currentDirectory, path);
        }
        File file3 = file2;
        if (file3 == null) {
            DiffApplicationBase.$$$reportNull$$$0(6);
        }
        return file3;
    }

    @NotNull
    public List<VirtualFile> replaceNullsWithEmptyFile(@NotNull List<VirtualFile> contents) {
        if (contents == null) {
            DiffApplicationBase.$$$reportNull$$$0(7);
        }
        List list2 = ContainerUtil.map(contents, file2 -> (VirtualFile)ObjectUtils.notNull((Object)file2, () -> new LightVirtualFile(NULL_PATH, (FileType)PlainTextFileType.INSTANCE, (CharSequence)"")));
        if (list2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public boolean canProcessExternalCommandLine() {
        return true;
    }

    @Nullable
    protected static Project guessProject(@NotNull List<? extends VirtualFile> files2) {
        Project project2;
        if (files2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(9);
        }
        HashSet projects = new HashSet();
        for (VirtualFile virtualFile : files2) {
            projects.addAll(ProjectLocator.getInstance().getProjectsForFile(virtualFile));
        }
        if (projects.isEmpty()) {
            Object[] openProjects = ProjectManager.getInstance().getOpenProjects();
            projects.addAll(ContainerUtil.filter((Object[])openProjects, project -> project.isInitialized() && !project.isDisposed()));
        }
        if (projects.isEmpty()) {
            return null;
        }
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (recentFocusedWindow instanceof IdeFrame && (project2 = ((IdeFrame)recentFocusedWindow).getProject()) != null && projects.contains(project2)) {
            return project2;
        }
        return (Project)projects.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/applications/DiffApplicationBase";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/applications/DiffApplicationBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceNullsWithEmptyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processExternalCommandLine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFiles";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndEnsureFilesValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceNullsWithEmptyFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

