/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseEx;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.HotSwapScriptManager;
import org.jetbrains.v8.liveEditProtocol.ScriptLiveChangeResult;
import org.jetbrains.wip.WipAsyncCallFrame;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipFunction;
import org.jetbrains.wip.WipNetworkManager;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipScriptKt;
import org.jetbrains.wip.WipScriptManager;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.ScriptParsedEventData;
import org.jetbrains.wip.protocol.debugger.SetScriptSourceResult;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001eB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bJ\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/wip/WipScriptManager;", "Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "Lorg/jetbrains/wip/WipScript;", "Lorg/jetbrains/v8/HotSwapScriptManager;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "containsScript", "", "script", "Lorg/jetbrains/debugger/Script;", "getScript", "frame", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/concurrency/Promise;", "function", "Lorg/jetbrains/debugger/values/FunctionValue;", "loadScriptSource", "", "rawUrlToOurUrl", "Lcom/intellij/util/Url;", "rawUrl", "scriptParsed", "data", "Lorg/jetbrains/wip/protocol/debugger/ScriptParsedEventData;", "isFromWorker", "setSourceOnRemote", "Lorg/jetbrains/v8/liveEditProtocol/ScriptLiveChangeResult;", "newSource", "", "Companion", "intellij.javascript.wip.backend"})
public final class WipScriptManager
extends ScriptManagerBaseEx<WipScript>
implements HotSwapScriptManager {
    private final WipVm vm;
    private static final Key<Integer> LAST_SET_SOURCE_HASHCODE_KEY;
    private static final Companion.UNCHANGED_STATUS.1 UNCHANGED_STATUS;
    public static final Companion Companion;

    public boolean containsScript(@NotNull Script script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return script instanceof WipScript && this.getIdToScript().containsKey(((WipScript)script).getId());
    }

    @NotNull
    protected Promise<String> loadScriptSource(@NotNull WipScript script) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)script), (String)"script");
        Promise promise2 = this.vm.getCommandProcessor().send((Request)DebuggerKt.GetScriptSource(script.getId())).then((Function)loadScriptSource.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"vm.commandProcessor.send\u2026hen { it.scriptSource() }");
        return promise2;
    }

    @Override
    @NotNull
    public Promise<ScriptLiveChangeResult> setSourceOnRemote(@NotNull Script script, @NotNull CharSequence newSource) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)newSource, (String)"newSource");
        Integer prevSourceHashCode = (Integer)script.getUserData(LAST_SET_SOURCE_HASHCODE_KEY);
        int newSourceHashCode = StringUtil.stringHashCode((CharSequence)newSource);
        Integer n = prevSourceHashCode;
        if (n != null && n == newSourceHashCode) {
            Promise promise2 = Promise.resolve((Object)UNCHANGED_STATUS);
            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.resolve(UNCHANGED_STATUS)");
            return promise2;
        }
        boolean replaced = script.replace(LAST_SET_SOURCE_HASHCODE_KEY, (Object)prevSourceHashCode, (Object)newSourceHashCode);
        if (!replaced) {
            Promise promise3 = Promise.resolve((Object)UNCHANGED_STATUS);
            Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"Promise.resolve(UNCHANGED_STATUS)");
            return promise3;
        }
        Promise promise4 = this.vm.getCommandProcessor().send((Request)DebuggerKt.SetScriptSource(((WipScript)script).getId(), newSource, false)).then(new Function<T, SUB_RESULT>(this){
            final /* synthetic */ WipScriptManager this$0;

            @NotNull
            public final Companion.UNCHANGED_STATUS.1 fun(SetScriptSourceResult it) {
                List<CallFrameValue> callFrames = it.getCallFrames();
                if (!UtilKt.isNullOrEmpty((Collection)callFrames)) {
                    WipSuspendContextManager wipSuspendContextManager = WipScriptManager.access$getVm$p(this.this$0).getSuspendContextManager();
                    List<CallFrameValue> list = callFrames;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    wipSuspendContextManager.updateStackTrace(list, it.getAsyncStackTrace());
                }
                return WipScriptManager.access$getUNCHANGED_STATUS$cp();
            }
            {
                this.this$0 = wipScriptManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise4, (String)"vm.commandProcessor.send\u2026 UNCHANGED_STATUS\n      }");
        return promise4;
    }

    @NotNull
    public Promise<Script> getScript(@NotNull FunctionValue function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        Promise promise2 = function.resolve().then(new Function<T, SUB_RESULT>(this){
            final /* synthetic */ WipScriptManager this$0;

            @Nullable
            public final WipScript fun(FunctionValue it) {
                FunctionValue functionValue = it;
                if (functionValue == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipFunction");
                }
                return (WipScript)this.this$0.findScriptById(((WipFunction)functionValue).getScriptId());
            }
            {
                this.this$0 = wipScriptManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"function.resolve()\n    .\u2026 WipFunction).scriptId) }");
        return promise2;
    }

    @Nullable
    public Script getScript(@NotNull CallFrame frame) {
        String scriptId;
        WipScriptManager scriptManager;
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        CallFrame callFrame = frame;
        if (callFrame instanceof WipCallFrame) {
            scriptManager = this;
            String string = ((WipCallFrame)frame).getScriptId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            scriptId = string;
        } else if (callFrame instanceof WipAsyncCallFrame) {
            scriptManager = this;
            scriptId = ((WipAsyncCallFrame)frame).getScriptId();
        } else {
            return null;
        }
        return (Script)scriptManager.findScriptById(scriptId);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Url rawUrlToOurUrl(@NotNull String rawUrl) {
        Url url;
        String absoluteUrl;
        Url tabUrl;
        Intrinsics.checkParameterIsNotNull((Object)rawUrl, (String)"rawUrl");
        if (StringsKt.startsWith$default((String)rawUrl, (String)"extensions::", (boolean)false, (int)2, null)) {
            return (Url)Urls.newUnparsable((String)rawUrl);
        }
        if (StringsKt.startsWith$default((String)rawUrl, (String)"dart:", (boolean)false, (int)2, null)) return Urls.newFromIdea((CharSequence)rawUrl);
        if (StringsKt.startsWith$default((String)rawUrl, (String)"package:", (boolean)false, (int)2, null)) {
            return Urls.newFromIdea((CharSequence)rawUrl);
        }
        Url url2 = Urls.parse((String)rawUrl, (boolean)true);
        if (url2 != null) {
            return url2;
        }
        Url url3 = tabUrl = this.vm.getCurrentUrl();
        CharSequence charSequence = url3 != null ? url3.getAuthority() : null;
        if (charSequence == null || charSequence.length() == 0) {
            return Urls.newLocalFileUrl((String)rawUrl);
        }
        Url url4 = tabUrl;
        if (url4 == null) {
            Intrinsics.throwNpe();
        }
        String string = url4.trimParameters().toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tabUrl!!.trimParameters().toExternalForm()");
        String documentUrl = string;
        int lastSlash = StringsKt.lastIndexOf$default((CharSequence)documentUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (lastSlash == -1) {
            absoluteUrl = documentUrl + '/' + rawUrl;
        } else {
            String string2 = documentUrl;
            int n = 0;
            int n2 = lastSlash + 1;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            absoluteUrl = stringBuilder.append(string5).append(rawUrl).toString();
        }
        Url parsedUrl = Urls.parseEncoded((String)absoluteUrl);
        if (parsedUrl != null) {
            WipNetworkManager wipNetworkManager = this.vm.getNetworkManager();
            String string6 = parsedUrl.trimParameters().toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"parsedUrl.trimParameters().toExternalForm()");
            if (wipNetworkManager.wasRequested(string6)) {
                url = parsedUrl;
                return url;
            }
        }
        url = (Url)Urls.newUnparsable((String)rawUrl);
        return url;
    }

    @NotNull
    public final Script scriptParsed(@NotNull ScriptParsedEventData data, boolean isFromWorker) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String id = data.scriptId();
        CharSequence charSequence = data.url();
        Url url = charSequence.length() == 0 ? (Url)Urls.newUri((String)"vm", (String)id) : this.rawUrlToOurUrl(data.url());
        WipScript script = isFromWorker ? WipScriptKt.newWorkerScript(id, url) : new WipScript(id, Script.Type.NORMAL, url, data.getStartLine(), data.getStartColumn(), data.getEndLine(), false, data.getLength(), data.getHasSourceURL());
        WipScript existingScript = this.getIdToScript().putIfAbsent(id, script);
        if (existingScript != null) {
            return (Script)existingScript;
        }
        if (url.getScheme() != null || !StringsKt.startsWith$default((String)data.url(), (String)"extensions::", (boolean)false, (int)2, null)) {
            this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)script, data.getSourceMapURL());
        }
        return (Script)script;
    }

    public WipScriptManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
    }

    static {
        Companion = new Companion(null);
        LAST_SET_SOURCE_HASHCODE_KEY = new Key("js.debugger.last.set.source.hashcode");
        UNCHANGED_STATUS = new ScriptLiveChangeResult(){
            @NotNull
            private final ScriptLiveChangeResult.ChangeStatus status;
            @Nullable
            private final String statusExplanation;

            @NotNull
            public ScriptLiveChangeResult.ChangeStatus getStatus() {
                return this.status;
            }

            @Nullable
            public String getStatusExplanation() {
                return this.statusExplanation;
            }

            public void doRecommended() {
            }
            {
                this.status = ScriptLiveChangeResult.ChangeStatus.UNCHANGED;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ WipVm access$getVm$p(WipScriptManager $this) {
        return $this.vm;
    }

    @NotNull
    public static final /* synthetic */ Companion.UNCHANGED_STATUS.1 access$getUNCHANGED_STATUS$cp() {
        return UNCHANGED_STATUS;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003*\u0001\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/wip/WipScriptManager$Companion;", "", "()V", "LAST_SET_SOURCE_HASHCODE_KEY", "Lcom/intellij/openapi/util/Key;", "", "UNCHANGED_STATUS", "org/jetbrains/wip/WipScriptManager$Companion$UNCHANGED_STATUS$1", "Lorg/jetbrains/wip/WipScriptManager$Companion$UNCHANGED_STATUS$1;", "intellij.javascript.wip.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

