/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.mssql.TsqlDefinitionProviderBase;
import com.intellij.database.dialects.sybase.SybaseDialect;
import com.intellij.database.dialects.sybase.model.AseProcedure;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDefinitionProvider
extends TsqlDefinitionProviderBase {
    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.TRIGGER;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection2, @NotNull PairConsumer<DasObject, Object> consumer2) {
        if (objects == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(3);
        }
        DatabaseDialectEx dialect = DatabaseDialects.getGenericDialect();
        StringBuilder builder = new StringBuilder();
        try (ReusableSmartStatement<ParameterizedStatementDecoration> statement = SmartStatements.poweredBy(connection2).parameterized().reuse("exec sp_helptext ?, ?");){
            for (DasObject dasObject : objects) {
                DasObject parent2 = dasObject.getDasParent();
                boolean procGroup = DasUtil.getKind((DasObject)parent2) == ObjectKind.PACKAGE;
                String objName = procGroup ? DasUtil.getName((DasObject)parent2) : dasObject.getName();
                String name = dialect.quoteIdentifier(DasUtil.getSchema((DasObject)dasObject), true, false) + "." + dialect.quoteIdentifier(objName, true, false);
                Integer procNum = procGroup ? SybaseDefinitionProvider.getProcNum(dasObject) : null;
                StatementParameters parameters = new StatementParameters().text(name);
                parameters = procNum == null ? parameters.integer(null) : parameters.integer(procNum);
                ParameterizedStatementDecoration data = parameters.asDecoration();
                try {
                    ClosableResultsProducer producer = statement.noisy().execute(data, StandardExecutionMode.QUERY);
                    Throwable throwable = null;
                    try {
                        boolean ok;
                        ResultSet rs = null;
                        boolean bl = ok = producer.advance() && (rs = producer.processCurrent(StandardResultsProcessors.RESULT_SET)) != null;
                        if (rs != null && !"text".equalsIgnoreCase(rs.getMetaData().getColumnLabel(1))) {
                            boolean advanced = producer.advance();
                            boolean bl2 = ok = advanced && (rs = producer.processCurrent(StandardResultsProcessors.RESULT_SET)) != null;
                            if (!ok && advanced && producer.processCurrent(StandardResultsProcessors.updateCount(-1)) != -1) {
                                ok = producer.advance() && (rs = producer.processCurrent(StandardResultsProcessors.RESULT_SET)) != null;
                            }
                        }
                        builder.setLength(0);
                        if (ok) {
                            while (rs.next()) {
                                builder.append(rs.getString(1));
                            }
                        }
                        consumer2.consume((Object)dasObject, (Object)StringUtil.nullize((String)builder.toString()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (producer == null) continue;
                        if (throwable != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        producer.close();
                    }
                }
                catch (SQLException e) {
                    consumer2.consume((Object)dasObject, (Object)e);
                }
            }
        }
    }

    @Override
    @Nullable
    protected String getCurrentDb(@NotNull DatabaseConnection connection2) throws SQLException {
        SybaseDialect dialect;
        ObjectPath current;
        if (connection2 == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(4);
        }
        return (current = SearchPath.getCurrent((SearchPath)(dialect = SybaseDialect.INSTANCE).tryToLoadSearchPath(connection2.getConnectionPoint().getDataSource(), connection2))) == null ? null : current.getName();
    }

    private static Integer getProcNum(DasObject obj) {
        int res2;
        int n = res2 = obj instanceof AseProcedure ? ((AseProcedure)obj).getPosition() : StringUtil.parseInt((String)obj.getName(), (int)-1);
        return res2 == -1 ? null : Integer.valueOf(res2 == 0 ? 1 : res2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sybase/SybaseDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentDb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

