/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.TerminalColor;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public class TextStyle
implements Cloneable {
    public static final EnumSet<Option> NO_OPTIONS = EnumSet.noneOf(Option.class);
    public static final TextStyle EMPTY = new TextStyle();
    private static final WeakHashMap<TextStyle, WeakReference<TextStyle>> styles = new WeakHashMap();
    private TerminalColor myForeground;
    private TerminalColor myBackground;
    private EnumSet<Option> myOptions;

    public TextStyle() {
        this(null, null, NO_OPTIONS);
    }

    public TextStyle(TerminalColor foreground, TerminalColor background) {
        this(foreground, background, NO_OPTIONS);
    }

    public TextStyle(TerminalColor foreground, TerminalColor background, EnumSet<Option> options) {
        this.myForeground = foreground;
        this.myBackground = background;
        this.myOptions = options.clone();
    }

    public void setBackground(TerminalColor background) {
        this.myBackground = background;
    }

    public void setForeground(TerminalColor foreground) {
        this.myForeground = foreground;
    }

    public void setOptions(EnumSet<Option> options) {
        this.myOptions = options;
    }

    public void setOption(Option opt, boolean val) {
        this.setOptions(opt.set(EnumSet.copyOf(this.myOptions), val));
    }

    public TextStyle readonlyCopy() {
        return new TextStyle(this.myForeground, this.myBackground, this.myOptions){

            private TextStyle readonly() {
                throw new IllegalStateException("Text Style is readonly");
            }

            @Override
            public void setBackground(TerminalColor background) {
                this.readonly();
            }

            @Override
            public void setForeground(TerminalColor foreground) {
                this.readonly();
            }

            @Override
            public void setOptions(EnumSet<Option> options) {
                this.readonly();
            }
        };
    }

    @NotNull
    public static TextStyle getCanonicalStyle(TextStyle currentStyle) {
        TextStyle canonStyle;
        WeakReference<TextStyle> canonRef = styles.get(currentStyle);
        if (canonRef != null && (canonStyle = (TextStyle)canonRef.get()) != null) {
            return canonStyle;
        }
        styles.put(currentStyle, new WeakReference<TextStyle>(currentStyle));
        return currentStyle;
    }

    public TerminalColor getForeground() {
        return this.myForeground;
    }

    public TerminalColor getBackground() {
        return this.myBackground;
    }

    public TextStyle clone() {
        return new TextStyle(this.myForeground, this.myBackground, this.myOptions);
    }

    public TextStyle createEmptyWithColors() {
        return new TextStyle(this.myForeground, this.myBackground);
    }

    public int getId() {
        return this.hashCode();
    }

    public boolean hasOption(Option option) {
        return this.myOptions.contains((Object)option);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.myBackground == null ? 0 : this.myBackground.hashCode());
        result = 31 * result + (this.myForeground == null ? 0 : this.myForeground.hashCode());
        result = 31 * result + (this.myOptions == null ? 0 : this.myOptions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextStyle other = (TextStyle)obj;
        if (this.myBackground == null ? other.myBackground != null : !this.myBackground.equals(other.myBackground)) {
            return false;
        }
        if (this.myForeground == null ? other.myForeground != null : !this.myForeground.equals(other.myForeground)) {
            return false;
        }
        return !(this.myOptions == null ? other.myOptions != null : !this.myOptions.equals(other.myOptions));
    }

    public TerminalColor getBackgroundForRun() {
        return this.myOptions.contains((Object)Option.INVERSE) ? this.myForeground : this.myBackground;
    }

    public TerminalColor getForegroundForRun() {
        return this.myOptions.contains((Object)Option.INVERSE) ? this.myBackground : this.myForeground;
    }

    public void clearOptions() {
        this.myOptions.clear();
    }

    public static enum Option {
        BOLD,
        ITALIC,
        BLINK,
        DIM,
        INVERSE,
        UNDERLINED,
        HIDDEN;


        public EnumSet<Option> set(EnumSet<Option> options, boolean val) {
            if (val) {
                options.add(this);
            } else {
                options.remove((Object)this);
            }
            return options;
        }
    }
}

