/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import org.owasp.html.AttributePolicy;
import org.owasp.html.FilterUrlByProtocolAttributePolicy;
import org.owasp.html.Strings;
import org.owasp.html.TCB;

@TCB
final class StandardUrlAttributePolicy
implements AttributePolicy {
    static final StandardUrlAttributePolicy INSTANCE = new StandardUrlAttributePolicy();

    private StandardUrlAttributePolicy() {
    }

    public String apply(String elementName, String attributeName, String s) {
        int n = s.length();
        block9: for (int i = 0; i < n; ++i) {
            switch (s.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    break block9;
                }
                case ':': {
                    switch (i) {
                        case 4: {
                            if (Strings.regionMatchesIgnoreCase("http", 0, s, 0, 4)) break block9;
                            return null;
                        }
                        case 5: {
                            if (Strings.regionMatchesIgnoreCase("https", 0, s, 0, 5)) break block9;
                            return null;
                        }
                        case 6: {
                            if (Strings.regionMatchesIgnoreCase("mailto", 0, s, 0, 6)) break block9;
                            return null;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                default: {
                    continue block9;
                }
            }
        }
        return FilterUrlByProtocolAttributePolicy.normalizeUri(s);
    }
}

