/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.util.BugLog;

public abstract class AbstractFileObject {
    private final String path;

    public abstract boolean isDirectory();

    protected AbstractFileObject(String path) {
        BugLog.getInstance().assertNotNull(path);
        BugLog.getInstance().assertTrue(path.startsWith("/"), "'" + path + "' must start with a /");
        BugLog.getInstance().assertTrue(path.length() == 1 || !path.endsWith("/"), "'" + path + "' must end with a /");
        this.path = path;
    }

    public final String toString() {
        return this.path;
    }

    public final int hashCode() {
        return this.path.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractFileObject abstractFileObject = (AbstractFileObject)obj;
        return this.path.equals(abstractFileObject.path);
    }

    public final String getName() {
        int lastSlashIndex = this.path.lastIndexOf(47);
        if (lastSlashIndex < 0) {
            return this.path;
        }
        return this.path.substring(lastSlashIndex + 1);
    }

    public final String getPath() {
        return this.path;
    }

    public final DirectoryObject getParent() {
        if (this.isRoot()) {
            return null;
        }
        int lastSlashIndex = this.path.lastIndexOf(47);
        if (lastSlashIndex == 0) {
            return DirectoryObject.getRoot();
        }
        return DirectoryObject.createInstance(this.path.substring(0, lastSlashIndex));
    }

    public final String getParentPath() {
        if (this.isRoot()) {
            return null;
        }
        int lastSlashIndex = this.path.lastIndexOf(47);
        if (lastSlashIndex == 0) {
            return "/";
        }
        return this.path.substring(0, lastSlashIndex);
    }

    public final String toUnixPath() {
        String pathWithoutLeadingSlash = this.getPath().substring(1);
        if (pathWithoutLeadingSlash.length() == 0) {
            return ".";
        }
        return pathWithoutLeadingSlash;
    }

    public final boolean isRoot() {
        return this.path.equals("/");
    }

    public static DirectoryObject getCommonDirectory(AbstractFileObject abstractFileObject1, AbstractFileObject abstractFileObject2) {
        String parentPath1 = AbstractFileObject.getDirectory(abstractFileObject1).getPath();
        String parentPath2 = AbstractFileObject.getDirectory(abstractFileObject2).getPath();
        int parentPathLength1 = parentPath1.length();
        int parentPathLength2 = parentPath2.length();
        int length = Math.min(parentPathLength1, parentPathLength2);
        int lastSlashIndex = 1;
        for (int i = 1; i < length; ++i) {
            char chr2;
            char chr1 = parentPath1.charAt(i);
            if (chr1 != (chr2 = parentPath2.charAt(i))) {
                return DirectoryObject.createInstance(parentPath1.substring(0, lastSlashIndex));
            }
            if (chr1 != '/') continue;
            lastSlashIndex = i;
        }
        if (parentPathLength1 == parentPathLength2) {
            return DirectoryObject.createInstance(parentPath1);
        }
        if (parentPathLength1 > parentPathLength2) {
            if (parentPath1.charAt(parentPathLength2) == '/') {
                return DirectoryObject.createInstance(parentPath2);
            }
            return DirectoryObject.createInstance(parentPath1.substring(0, lastSlashIndex));
        }
        if (parentPath2.charAt(parentPathLength1) == '/') {
            return DirectoryObject.createInstance(parentPath1);
        }
        return DirectoryObject.createInstance(parentPath1.substring(0, lastSlashIndex));
    }

    private static DirectoryObject getDirectory(AbstractFileObject abstractFileObject) {
        if (abstractFileObject.isDirectory()) {
            return (DirectoryObject)abstractFileObject;
        }
        return abstractFileObject.getParent();
    }
}

