/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.apacheConfig.ApacheConfigFileType;
import com.intellij.lang.apacheConfig.psi.ACArgument;
import com.intellij.lang.apacheConfig.psi.ACDirective;
import com.intellij.lang.apacheConfig.psi.ACPsiVisitor;
import com.intellij.lang.apacheConfig.rewriting.RewriteRule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ACFile
extends PsiFileBase {
    private static final Logger LOG = Logger.getInstance((String)ACFile.class.getName());

    public ACFile(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            ACFile.$$$reportNull$$$0(0);
        }
        super(viewProvider, language);
    }

    @NotNull
    public FileType getFileType() {
        ApacheConfigFileType apacheConfigFileType = ApacheConfigFileType.FILE_TYPE;
        if (apacheConfigFileType == null) {
            ACFile.$$$reportNull$$$0(1);
        }
        return apacheConfigFileType;
    }

    public String toString() {
        return "ACFile:" + this.getName();
    }

    public List<RewriteRule> getRewriteRules() {
        return this.collectRewriteRules();
    }

    private List<RewriteRule> collectRewriteRules() {
        RewriteRulesCollector collector = new RewriteRulesCollector();
        this.accept((PsiElementVisitor)collector);
        return collector.getRules();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/apacheConfig/psi/ACFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/apacheConfig/psi/ACFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RewriteRulesCollector
    extends ACPsiVisitor {
        private static final String NO_REWRITE = "-";
        private final List<RewriteRule> myRules = new ArrayList<RewriteRule>();
        private String myRewriteBase = null;
        private boolean myIsRewriteEnabled = false;

        private RewriteRulesCollector() {
        }

        @NotNull
        public List<RewriteRule> getRules() {
            List<RewriteRule> list = this.myRules;
            if (list == null) {
                RewriteRulesCollector.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public void visitACDirective(@NotNull ACDirective directive) {
            block17: {
                List<ACArgument> arguments;
                String name;
                if (directive == null) {
                    RewriteRulesCollector.$$$reportNull$$$0(1);
                }
                if ("RewriteEngine".equals(name = directive.getName())) {
                    List<ACArgument> arguments2 = directive.getArguments();
                    if (!arguments2.isEmpty()) {
                        this.myIsRewriteEnabled = StringUtil.equalsIgnoreCase((CharSequence)arguments2.get(0).getText(), (CharSequence)"on");
                    }
                } else if ("RewriteBase".equals(name)) {
                    List<ACArgument> arguments3 = directive.getArguments();
                    if (arguments3.size() == 1) {
                        this.myRewriteBase = arguments3.get(0).getText();
                    }
                } else if ("RewriteRule".equals(name) && this.myIsRewriteEnabled && (arguments = directive.getArguments()).size() > 1) {
                    String text;
                    ACArgument pattern = arguments.get(0);
                    ACArgument replacement = arguments.get(1);
                    String patternString = pattern.getText();
                    if (StringUtil.startsWith((CharSequence)patternString, (CharSequence)"^")) {
                        patternString = patternString.substring(1);
                    }
                    if (!StringUtil.startsWith((CharSequence)patternString, (CharSequence)"/")) {
                        patternString = "/?" + patternString;
                    }
                    if (StringUtil.equals((CharSequence)NO_REWRITE, (CharSequence)(text = replacement.getText()))) {
                        text = null;
                    } else {
                        if (!text.startsWith("/")) {
                            if (StringUtil.isEmpty((String)this.myRewriteBase)) {
                                this.myRewriteBase = RewriteRulesCollector.getContainingRelativeDir(directive);
                            }
                            if (StringUtil.isNotEmpty((String)this.myRewriteBase)) {
                                boolean addSlash = !this.myRewriteBase.endsWith("/");
                                text = this.myRewriteBase + (addSlash ? "/" : "") + text;
                            }
                        }
                        text = StringUtil.trimLeading((String)text, (char)'/');
                    }
                    try {
                        this.myRules.add(new RewriteRule(patternString, text));
                    }
                    catch (PatternSyntaxException e) {
                        if (!LOG.isDebugEnabled()) break block17;
                        LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        @Nullable
        private static String getContainingRelativeDir(@NotNull ACDirective directive) {
            PsiDirectory directory;
            if (directive == null) {
                RewriteRulesCollector.$$$reportNull$$$0(2);
            }
            if ((directory = directive.getContainingFile().getContainingDirectory()) != null) {
                VirtualFile file = directory.getVirtualFile();
                VirtualFile root = ProjectRootManager.getInstance((Project)directive.getProject()).getFileIndex().getContentRootForFile(file);
                if (root != null) {
                    return FileUtil.getRelativePath((String)root.getPath(), (String)file.getPath(), (char)'/');
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/apacheConfig/psi/ACFile$RewriteRulesCollector";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRules";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/apacheConfig/psi/ACFile$RewriteRulesCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitACDirective";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getContainingRelativeDir";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

