/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.DarculaAwareGraph2DPrinter;
import com.intellij.openapi.graph.builder.actions.printing.PrintOptionsDialog;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;

public class PrintGraphAction
extends AbstractGraphAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.graph.builder.actions.printing.PrintGraphAction");
    private PageFormat myPageFormat;

    public PrintGraphAction() {
    }

    public PrintGraphAction(Graph2D graph2D) {
        super(graph2D);
    }

    public void actionPerformed(AnActionEvent e, Graph2D graph2D) {
        PageFormat pf;
        Graph2DView view = PrintGraphAction.getGraph2DView(graph2D);
        BackgroundRenderer renderer = view.getBackgroundRenderer();
        GraphBuilder builder = (GraphBuilder)((Object)e.getDataContext().getData(GraphBuilder.GRAPH_BUILDER_KEY));
        DarculaAwareGraph2DPrinter printer = new DarculaAwareGraph2DPrinter(view);
        OptionHandler handler = PrintUtil.createPrintOptions();
        Project project = e.getProject();
        PrintOptionsDialog dialog = new PrintOptionsDialog(project, handler);
        if (!dialog.showAndGet()) {
            return;
        }
        PrintUtil.initGraph2DPrinter(printer, handler);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (this.myPageFormat == null) {
            this.myPageFormat = printJob.defaultPage();
        }
        if ((pf = printJob.pageDialog(this.myPageFormat)) == this.myPageFormat) {
            return;
        }
        this.myPageFormat = pf;
        printJob.setPrintable(printer, this.myPageFormat);
        PrintGraphAction.doPrint(graph2D, renderer, builder, printJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPrint(Graph2D graph2D, BackgroundRenderer renderer, GraphBuilder builder, PrinterJob printJob) {
        if (printJob.printDialog()) {
            try {
                PrintGraphAction.setupBackgroundBeforePrint(graph2D, renderer, builder);
                printJob.print();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            finally {
                PrintGraphAction.rollbackBackgroundAfterPrint(renderer, builder);
            }
        }
    }

    public static void setupBackgroundBeforePrint(Graph2D graph2D, BackgroundRenderer renderer, GraphBuilder builder) {
        if (UIUtil.isUnderDarcula()) {
            if (renderer instanceof DefaultBackgroundRenderer) {
                ((DefaultBackgroundRenderer)renderer).setColor(Color.white);
            }
            JBColor.setDark((boolean)false);
            GraphViewUtil.setPrintMode(true);
            graph2D.getCurrentView().updateView();
            if (builder != null) {
                builder.updateGraph();
                builder.getGraph().updateViews();
            }
        }
    }

    public static void rollbackBackgroundAfterPrint(BackgroundRenderer renderer, GraphBuilder builder) {
        if (UIUtil.isUnderDarcula()) {
            GraphViewUtil.setPrintMode(false);
            JBColor.setDark((boolean)UIUtil.isUnderDarcula());
            if (renderer instanceof DefaultBackgroundRenderer) {
                ((DefaultBackgroundRenderer)renderer).setColor(JBColor.background());
            }
            if (builder != null) {
                builder.updateGraph();
            }
        }
    }

    public void update(AnActionEvent e, Graph2D graph2D) {
        Presentation p = e.getPresentation();
        p.setText(ActionsBundle.message((String)"action.Graph.print", (Object[])new Object[0]));
        p.setIcon(AllIcons.Graph.Print);
    }
}

