/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.MysqlExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.MysqlIntermediateFacade;

public class MysqlIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final MysqlIntermediateProvider INSTANCE = new MysqlIntermediateProvider();
    static final Pattern MYSQL_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:(?:mysql|mariadb)://.+$");
    static final String MYSQL_CONNECTION_STRING_EXAMPLE = "jdbc:mysql:///";
    private static final String MYSQL_DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return MYSQL_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver(String connectionString) {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(MYSQL_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("MySQL Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Mysql.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return MYSQL_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected MysqlIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new MysqlIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, MysqlExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return MysqlExceptionRecognizer.INSTANCE;
    }
}

