/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.ConnectionSettingsImpl;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.connections.ext.ExtConnection;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.cvsSupport2.connections.ssh.SshAuthentication;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionPool;
import com.intellij.cvsSupport2.connections.ssh.SshPasswordAuthentication;
import com.intellij.cvsSupport2.connections.ssh.SshPublicKeyAuthentication;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;

public class CvsConnectionUtil {
    private CvsConnectionUtil() {
    }

    public static IConnection createSshConnection(CvsRootData settings, SshSettings sshConfiguration, ProxySettings proxySettings, SSHPasswordProvider sshPasswordProvider, int timeout) {
        ConnectionSettingsImpl connectionSettings = new ConnectionSettingsImpl(settings.HOST, settings.PORT, proxySettings.USE_PROXY, proxySettings.PROXY_HOST, proxySettings.PROXY_PORT, timeout, proxySettings.getType(), proxySettings.getLogin(), proxySettings.getPassword());
        SshAuthentication authentication = sshConfiguration.USE_PPK ? new SshPublicKeyAuthentication(new File(sshConfiguration.PATH_TO_PPK), CvsConnectionUtil.getUserName(settings), sshPasswordProvider, settings.getCvsRootAsString()) : new SshPasswordAuthentication(CvsConnectionUtil.getUserName(settings), sshPasswordProvider, settings.getCvsRootAsString());
        return SshConnectionPool.getInstance().getConnection(settings.REPOSITORY, connectionSettings, authentication);
    }

    public static IConnection createExtConnection(CvsRootData settings, ExtConfiguration extConfiguration, SshSettings sshConfiguration, SSHPasswordProvider sshPasswordProvider, ProxySettings proxySettings, ErrorRegistry errorRegistry, int timeout) {
        if (extConfiguration.USE_INTERNAL_SSH_IMPLEMENTATION) {
            return CvsConnectionUtil.createSshConnection(settings, sshConfiguration, proxySettings, sshPasswordProvider, timeout);
        }
        return new ExtConnection(settings.HOST, CvsConnectionUtil.getUserName(settings), settings.REPOSITORY, extConfiguration, errorRegistry);
    }

    public static IConnection createPServerConnection(CvsRootData root, ProxySettings proxySettings, int timeout) {
        ConnectionSettingsImpl connectionSettings = new ConnectionSettingsImpl(root.HOST, root.PORT, proxySettings.USE_PROXY, proxySettings.PROXY_HOST, proxySettings.PROXY_PORT, timeout, proxySettings.TYPE, proxySettings.getLogin(), proxySettings.getPassword());
        return new PServerConnection((ConnectionSettings)connectionSettings, root.USER, root.PASSWORD, CvsConnectionUtil.adjustRepository(root));
    }

    private static String getUserName(CvsRootData settings) {
        return settings.USER.isEmpty() ? SystemProperties.getUserName() : settings.USER;
    }

    private static String adjustRepository(CvsRootData root) {
        return root.REPOSITORY != null ? root.REPOSITORY.replace('\\', '/') : null;
    }
}

