/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.data;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.framework.data.FrameworkDataServiceBase;
import org.jetbrains.annotations.Nullable;

public class FrameworkApplicationDataService
extends FrameworkDataServiceBase {
    public static FrameworkApplicationDataService getInstance() {
        return (FrameworkApplicationDataService)ServiceManager.getService(FrameworkApplicationDataService.class);
    }

    protected FrameworkApplicationDataService() {
        this.initialize();
    }

    @Override
    @Nullable
    protected VirtualFile getDescriptionsDir(boolean createIfNotFound) {
        VirtualFile configDir;
        String configDirPath = PathManager.getConfigPath();
        if (createIfNotFound) {
            PathManager.ensureConfigFolderExists();
        }
        if ((configDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(configDirPath)) == null) {
            return null;
        }
        return FrameworkApplicationDataService.getOrCreateChildDir(configDir, "commandlinetools", createIfNotFound);
    }

    @Override
    protected boolean isProjectLevel() {
        return false;
    }
}

