/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.components.SearchResultsTreeModelFactory;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8DistancesInspection;
import com.jetbrains.nodejs.run.profile.heap.view.models.RetainersTreeModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class DistancesInspectionResultsModel
extends SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> {
    public static final Object DESCRIPTION = new Object();
    public static final Object FOUND_BY_TYPE = new Object();
    public static final Object FOUND_BY_NAME = new Object();

    public DistancesInspectionResultsModel(Project project, V8CachingReader reader, V8DistancesInspection inspection) {
        super(DistancesInspectionResultsModel.createColumns(project, reader));
        this.addTopKey(this.createNode(DESCRIPTION));
        int numResults = this.byTypeSubtree(reader, inspection);
        numResults = this.byNamesSubtree(reader, inspection, numResults);
        this.setNumResults(numResults);
    }

    private int byNamesSubtree(V8CachingReader reader, V8DistancesInspection inspection, int numResults) {
        ChainTreeTableModel.Node namesNode = this.createNode(FOUND_BY_NAME);
        this.addTopKey(namesNode);
        ArrayList<List<Long>> byNamesList = inspection.getByNamesList();
        for (List<Long> list : byNamesList) {
            if (list.isEmpty()) continue;
            V8HeapEdge firstEdge = reader.getEdge(list.get(0));
            ChainTreeTableModel.Node nameNode = this.createNode(Pair.create((Object)reader.getString(firstEdge.getNameId()), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            namesNode.getChildren().add(nameNode);
            ++numResults;
            ArrayList<V8HeapEdge> edges = new ArrayList<V8HeapEdge>(list.size());
            HashSet<Long> nodesIds = new HashSet<Long>();
            for (Long edge : list) {
                V8HeapEdge heapEdge = reader.getEdge(edge);
                if (nodesIds.contains(heapEdge.getToIndex())) continue;
                edges.add(heapEdge);
                nodesIds.add(heapEdge.getToIndex());
            }
            Collections.sort(edges, (o1, o2) -> {
                V8HeapEntry node1 = reader.getNode(o1.getToIndex());
                V8HeapEntry node2 = reader.getNode(o2.getToIndex());
                if (node1.getClassIndex() != node2.getClassIndex()) {
                    String typeName1 = Aggregate.getClassNameByClassIdx(reader, node1.getClassIndex());
                    String typeName2 = Aggregate.getClassNameByClassIdx(reader, node2.getClassIndex());
                    return typeName1.compareTo(typeName2);
                }
                return Integer.compare(reader.getDistance((int)o2.getToIndex()), reader.getDistance((int)o1.getToIndex()));
            });
            for (V8HeapEdge heapEdge : edges) {
                V8HeapContainmentTreeTableModel.NamedEntry namedEntry = V8HeapContainmentTreeTableModel.NamedEntry.create(heapEdge, reader);
                ChainTreeTableModel.Node node = this.createNode(namedEntry);
                nameNode.getChildren().add(node);
            }
            nameNode.setMeaningfulChildren(edges.size());
        }
        return numResults;
    }

    private int byTypeSubtree(V8CachingReader reader, V8DistancesInspection inspection) {
        ChainTreeTableModel.Node typesNode = this.createNode(FOUND_BY_TYPE);
        this.addTopKey(typesNode);
        int numResults = 0;
        TreeMap<Long, V8DistancesInspection.TypeData> sortedByTypes = inspection.getSortedByTypes();
        for (Map.Entry<Long, V8DistancesInspection.TypeData> entry : sortedByTypes.entrySet()) {
            String typeName = Aggregate.getClassNameByClassIdx(reader, entry.getKey());
            ChainTreeTableModel.Node typeNode = this.createNode(Pair.create((Object)typeName, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            typesNode.getChildren().add(typeNode);
            ++numResults;
            TreeMap<Integer, Pair<V8HeapEntry, V8HeapEdge>> map = entry.getValue().getMap();
            NavigableSet<Integer> set = map.descendingKeySet();
            typeNode.setMeaningfulChildren(set.size());
            typeNode.setOnlyPartOfChildren(entry.getValue().isSomethingMissing());
            for (Integer distance : set) {
                Pair<V8HeapEntry, V8HeapEdge> pair = map.get(distance);
                V8HeapContainmentTreeTableModel.NamedEntry namedEntry = pair.getSecond() != null ? V8HeapContainmentTreeTableModel.NamedEntry.create((V8HeapEdge)pair.getSecond(), reader) : V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(((V8HeapEntry)pair.getFirst()).getId(), reader);
                ChainTreeTableModel.Node node = this.createNode(namedEntry);
                typeNode.getChildren().add(node);
            }
        }
        return numResults;
    }

    private static ColumnInfo[] createColumns(Project project, V8CachingReader reader) {
        ColumnInfo[] columnInfos = new ColumnInfo[4];
        DirectTreeTableRenderer renderer = new DirectTreeTableRenderer(project, reader){

            @Override
            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof ChainTreeTableModel.Node) {
                    Object obj = ((ChainTreeTableModel.Node)value).getT();
                    if (obj == DESCRIPTION) {
                        this.setBackground(null);
                        this.append("This inspection shows groups of objects with similar class/name, which have different distances (range > 5)", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (obj == FOUND_BY_TYPE) {
                        this.setBackground(null);
                        this.append("Classes with distances variation", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (obj == FOUND_BY_NAME) {
                        this.setBackground(null);
                        this.append("Same-named objects with distances variation", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (obj instanceof Pair && ((Pair)obj).getFirst() instanceof String && ((Pair)obj).getSecond() instanceof SimpleTextAttributes) {
                        this.setBackground(null);
                        SimpleTextAttributes attributes = (SimpleTextAttributes)((Pair)obj).getSecond();
                        if (selected) {
                            attributes = new SimpleTextAttributes(attributes.getBgColor(), SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES.getFgColor(), attributes.getWaveColor(), attributes.getStyle());
                        }
                        this.append(((Pair)obj).getFirst().toString(), attributes);
                    } else {
                        super.customizeCellRenderer(tree, obj, selected, expanded, leaf, row, hasFocus);
                    }
                    int count = ((ChainTreeTableModel.Node)value).getMeaningfulChildren();
                    boolean partly = ((ChainTreeTableModel.Node)value).isOnlyPartOfChildren();
                    if (count > 0) {
                        SimpleTextAttributes attributes;
                        SimpleTextAttributes simpleTextAttributes = attributes = selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
                        if (count == 1) {
                            this.append(" (" + count + " occurrence)", attributes);
                        } else if (partly) {
                            this.append(" (Only " + count + " of found occurrences shown)", attributes);
                        } else {
                            this.append(" (" + count + " occurrences)", attributes);
                        }
                    }
                } else {
                    super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/nodejs/run/profile/heap/view/components/DistancesInspectionResultsModel$1", "customizeCellRenderer"));
            }
        };
        renderer.setReverseAsDirect(true);
        RetainersTreeModel.fillColumns(project, columnInfos, reader, renderer);
        return columnInfos;
    }
}

