/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairProcessor;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8ImportantStringsHolder;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8DistancesCalculator {
    private static final int NO_DISTANCE = -5;
    public static final int SYSTEM_DISTANCE = 100000000;
    private final TIntArrayList myDistances;
    private final TIntArrayList myParents;
    private final int myNodesCnt;
    private final V8CachingReader myReader;
    @Nullable
    private final V8HeapEntry myDocumentDOMTreeRoot;
    @Nullable
    private final V8HeapEntry myGcRootsRoot;
    private final V8ImportantStringsHolder myStringsHolder;
    private int myVisitedCnt;
    private static final String SLOPPY = "sloppy_function_map";
    private static final String SYSTEM_NATIVE = "system / NativeContext";
    private static final String MAP_DESCRIPTORS = "(map descriptors)";

    public V8DistancesCalculator(int nodesCnt, @NotNull V8CachingReader reader, @Nullable V8HeapEntry documentDOMTreeRoot, @Nullable V8HeapEntry gcRootsRoot, V8ImportantStringsHolder stringsHolder) {
        if (reader == null) {
            V8DistancesCalculator.$$$reportNull$$$0(0);
        }
        this.myNodesCnt = nodesCnt;
        this.myReader = reader;
        this.myDocumentDOMTreeRoot = documentDOMTreeRoot;
        this.myGcRootsRoot = gcRootsRoot;
        this.myStringsHolder = stringsHolder;
        this.myDistances = new TIntArrayList();
        this.myParents = new TIntArrayList();
        this.myVisitedCnt = 0;
    }

    public void execute() {
        for (int i = 0; i < this.myNodesCnt; ++i) {
            this.myDistances.add(-5);
            this.myParents.add(-1);
        }
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        this.foreachUserRoot((Consumer<Integer>)((Consumer)idx -> this.enqueue((int)idx, 1, queue, 0)));
        PairProcessor<V8HeapEntry, V8HeapEdge> filter = this.createFilter();
        this.bfs(queue, filter);
        this.myVisitedCnt = 0;
        queue.clear();
        this.foreachRoot((PairConsumer<Integer, Integer>)((PairConsumer)(idx, parent) -> this.enqueue((int)idx, 100000000, queue, (int)parent)));
        this.bfs(queue, filter);
    }

    @NotNull
    public PairProcessor<V8HeapEntry, V8HeapEdge> createFilter() {
        PairProcessor pairProcessor = (node, edge) -> {
            if (V8HeapNodeType.kHidden.equals((Object)node.getType())) {
                boolean isSloppy = edge.hasStringName() && this.myStringsHolder.get(SLOPPY) == edge.getNameId();
                boolean isSystemNative = this.myStringsHolder.get(SYSTEM_NATIVE) == node.getNameId();
                return !isSloppy || !isSystemNative;
            }
            if (V8HeapNodeType.kArray.equals((Object)node.getType())) {
                if (this.myStringsHolder.get(MAP_DESCRIPTORS) != node.getNameId()) {
                    return true;
                }
                Integer integer = edge.nameAsInt(this.myReader);
                return integer != null && (integer < 2 || integer % 3 != 1);
            }
            return true;
        };
        if (pairProcessor == null) {
            V8DistancesCalculator.$$$reportNull$$$0(1);
        }
        return pairProcessor;
    }

    private void foreachUserRoot(Consumer<Integer> consumer) {
        if (this.myGcRootsRoot == null) {
            return;
        }
        TIntHashSet visited = new TIntHashSet();
        Consumer action = integer -> {
            if (!visited.contains(integer.intValue())) {
                visited.add(integer.intValue());
                consumer.consume(integer);
            }
        };
        for (V8HeapEdge edge : this.myReader.getChildrenByNodeId(0L)) {
            if (!this.isUserRoot((int)edge.getToIndex())) continue;
            action.consume((Object)((int)edge.getToIndex()));
        }
    }

    private void foreachRoot(PairConsumer<Integer, Integer> consumer) {
        if (this.myGcRootsRoot == null) {
            return;
        }
        TIntHashSet visited = new TIntHashSet();
        PairConsumer action = (integer, parent) -> {
            if (!visited.contains(integer.intValue())) {
                visited.add(integer.intValue());
                consumer.consume(integer, parent);
            }
        };
        for (V8HeapEdge edge : this.myReader.getChildren(this.myGcRootsRoot)) {
            for (V8HeapEdge innerEdge : this.myReader.getChildrenByNodeId(edge.getToIndex())) {
                action.consume((Object)((int)innerEdge.getToIndex()), (Object)((int)edge.getToIndex()));
            }
            action.consume((Object)((int)edge.getToIndex()), (Object)((int)this.myGcRootsRoot.getId()));
        }
        for (V8HeapEdge edge : this.myReader.getChildrenByNodeId(0L)) {
            action.consume((Object)((int)edge.getToIndex()), (Object)0);
        }
    }

    private boolean isUserRoot(int nodeIdx) {
        if (this.myDocumentDOMTreeRoot != null && this.myDocumentDOMTreeRoot.getId() == (long)nodeIdx) {
            return true;
        }
        return !V8HeapNodeType.kSynthetic.equals((Object)this.myReader.getNode(nodeIdx).getType());
    }

    private void enqueue(int nodeIdx, int distance, ArrayDeque<Integer> queue, int parentNode) {
        if (this.myDistances.get(nodeIdx) != -5) {
            return;
        }
        this.myDistances.set(nodeIdx, distance);
        this.myParents.set(nodeIdx, parentNode);
        queue.addLast(nodeIdx);
        ++this.myVisitedCnt;
    }

    private void bfs(ArrayDeque<Integer> queue, @NotNull PairProcessor<V8HeapEntry, V8HeapEdge> filter) {
        if (filter == null) {
            V8DistancesCalculator.$$$reportNull$$$0(2);
        }
        while (!queue.isEmpty()) {
            int nodeIdx = queue.removeFirst();
            int newDistance = this.myDistances.get(nodeIdx) + 1;
            V8HeapEntry node = this.myReader.getNode(nodeIdx);
            for (V8HeapEdge edge : this.myReader.getChildren(node)) {
                int edgeToIndex;
                if (V8HeapGraphEdgeType.kWeak.equals((Object)edge.getType()) || this.myDistances.get(edgeToIndex = (int)edge.getToIndex()) != -5 || !filter.process((Object)node, (Object)edge)) continue;
                this.myDistances.set(edgeToIndex, newDistance);
                this.myParents.set(edgeToIndex, nodeIdx);
                queue.addLast(edgeToIndex);
                ++this.myVisitedCnt;
            }
        }
        if (this.myVisitedCnt > this.myNodesCnt) {
            // empty if block
        }
    }

    public TIntArrayList getDistances() {
        return this.myDistances;
    }

    public TIntArrayList getParents() {
        return this.myParents;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8DistancesCalculator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8DistancesCalculator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bfs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

