/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.exception.DockerClientException;
import com.intellij.docker.agent.ApiTaskException;
import java.io.IOException;

public abstract class ApiTask<T> {
    public T perform() {
        try {
            return this.doPerform();
        }
        catch (InterruptedException ex) {
            this.onError(ex);
            return null;
        }
        catch (Error e) {
            this.onError(e);
            return null;
        }
        catch (DockerClientException ex) {
            this.onError(ex);
            return null;
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause.toString().equals(ex.getMessage())) {
                this.onError(cause);
            } else {
                this.onError(ex);
            }
            return null;
        }
        catch (IOException ex) {
            this.onError(ex);
            return null;
        }
        catch (ApiTaskException ex) {
            this.onError(ex.getMessage());
            return null;
        }
    }

    private void onError(Throwable e) {
        StringBuilder errorBuilder = new StringBuilder(e.toString());
        Throwable cause = e.getCause();
        if (cause != null) {
            errorBuilder.append("<br/>caused by: ").append(cause.toString());
        }
        this.onError(errorBuilder.toString());
    }

    protected abstract T doPerform() throws IOException, ApiTaskException, InterruptedException;

    protected abstract void onError(String var1);
}

