/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.intellij.docker.agent.AgentLogSettings;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class AgentLogConfigurator {
    private AgentLogConfigurator() {
    }

    public static void configure(AgentLogSettings logSettings) {
        File file = new File(logSettings.getLogPath() + "/docker.log");
        Logger root = Logger.getRootLogger();
        root.setLevel(Level.INFO);
        PatternLayout pattern = new PatternLayout("%d [%7r] %6p - %30.30c - %m\n");
        try {
            RollingFileAppender fileAppender = new RollingFileAppender((Layout)pattern, file.getAbsolutePath());
            fileAppender.setMaxFileSize("1MB");
            fileAppender.setMaxBackupIndex(10);
            root.addAppender((Appender)fileAppender);
            for (String name : logSettings.getDebugLogCategories()) {
                Logger.getLogger((String)name).setLevel(Level.TRACE);
            }
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for Docker agent: " + e.getLocalizedMessage());
        }
    }
}

