/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStub;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionImpl<StubT extends JSFunctionStub<?>>
extends JSFunctionBaseImpl<StubT>
implements JSSuppressionHolder,
JSFunctionDeclaration {
    public static final Icon CONSTRUCTOR_ICON = AllIcons.Nodes.Method;
    private static final Key<ParameterizedCachedValue<JSNamespace, JSFunctionImpl<?>>> NAMESPACE_PROVIDER_KEY = Key.create((String)"js.function.symbol.namespace");
    private static final ParameterizedCachedValueProvider<JSNamespace, JSFunctionImpl<?>> NAMESPACE_PROVIDER = param -> {
        JSFunctionStub stub = (JSFunctionStub)param.getGreenStub();
        JSNamespace data = stub != null ? stub.getJSNamespace() : param.calculateSymbolNamespace();
        return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{param.getContainingFile()});
    };

    public JSFunctionImpl(ASTNode node) {
        super(node);
    }

    public JSFunctionImpl(StubT stub, IStubElementType type) {
        super(stub, type);
    }

    @Nullable
    public static JSType getReturnTypeInContext(@NotNull JSFunctionItem function, @Nullable PsiElement place) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(0);
        }
        return JSFunctionImpl.getReturnTypeInContext(function, place, JSExpectedTypeKind.CONTEXTUAL);
    }

    @Nullable
    public static JSType getReturnTypeInContext(@NotNull JSFunctionItem function, @Nullable PsiElement place, JSExpectedTypeKind kind) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(1);
        }
        JSType returnType = JSFunctionImpl.evaluateReturnTypeFromHierarchy(function);
        if (DialectDetector.isActionScript((PsiElement)function)) {
            return JSFunctionImpl.getActionScriptReturnTypeFromVector(function, place, returnType);
        }
        return JSFunctionImpl.getWidenReturnType(function, kind, returnType);
    }

    @Nullable
    private static JSType getWidenReturnType(@NotNull JSFunctionItem function, @NotNull JSExpectedTypeKind kind, @Nullable JSType returnType) {
        PsiElement sourceElement;
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            JSFunctionImpl.$$$reportNull$$$0(3);
        }
        if (!DialectDetector.isTypeScript((PsiElement)function)) {
            return JSTypeUtils.getApparentType(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(returnType));
        }
        PsiElement psiElement = sourceElement = returnType == null ? null : returnType.getSource().getSourceElement();
        if (sourceElement != null && sourceElement.getContext() instanceof JSReturnStatement) {
            return JSFunctionImpl.widenOneStatementReturnType(function, kind, returnType);
        }
        if (returnType instanceof JSUnionType && sourceElement == function) {
            return JSFunctionImpl.widenMultiStatementReturnType(function, (JSUnionType)returnType);
        }
        return returnType;
    }

    @Nullable
    private static JSType widenMultiStatementReturnType(@NotNull JSFunctionItem function, @NotNull JSUnionType returnType) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(4);
        }
        if (returnType == null) {
            JSFunctionImpl.$$$reportNull$$$0(5);
        }
        JSType type = TypeScriptTypeRelations.expandAliasesRecursive(returnType);
        boolean prohibitWidening = false;
        if (type instanceof JSUnionType && ((JSUnionType)type).getTypes().stream().allMatch(JSTypeUtils::containsLiteralTypes)) {
            prohibitWidening = true;
        }
        if (!prohibitWidening) {
            return JSFunctionImpl.subtypeReduction(function, JSTypeUtils.getApparentType(JSCompositeTypeImpl.optimizeTypeIfComposite(type)));
        }
        return JSFunctionImpl.subtypeReduction(function, JSCompositeTypeImpl.optimizeTypeIfComposite(type));
    }

    @Contract(value="_,!null->!null")
    private static JSType subtypeReduction(@NotNull JSFunctionItem function, @Nullable JSType type) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(6);
        }
        if (!(type instanceof JSUnionType)) {
            return type;
        }
        List<JSType> types = ((JSUnionType)type).getTypes();
        ProcessingContext subtypingProcessingContext = JSTypeComparingContextService.getSubtypingProcessingContext((PsiElement)function);
        if (types.stream().noneMatch(el -> el instanceof JSRecordType)) {
            return type;
        }
        Optional<JSType> notRecordType = types.stream().filter(el -> !(el instanceof JSRecordType)).findAny();
        if (!notRecordType.isPresent()) {
            return type;
        }
        JSType jsType = notRecordType.get();
        return notRecordType.map(el -> {
            Predicate subtypeCondition;
            JSType result2;
            if (function == null) {
                JSFunctionImpl.$$$reportNull$$$0(22);
            }
            return (result2 = TypeScriptTypeRelations.filterType(type, (Predicate<? super JSType>)(subtypeCondition = candidate -> candidate == jsType || !TypeScriptTypeRelations.isTypeSubtypeOf(candidate, jsType, subtypingProcessingContext)), (PsiElement)function)) instanceof TypeScriptNeverJSTypeImpl ? type : result2;
        }).orElse(type);
    }

    @Nullable
    private static JSType widenOneStatementReturnType(@NotNull JSFunctionItem function, @NotNull JSExpectedTypeKind kind, @NotNull JSType returnType) {
        JSType type;
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(7);
        }
        if (kind == null) {
            JSFunctionImpl.$$$reportNull$$$0(8);
        }
        if (returnType == null) {
            JSFunctionImpl.$$$reportNull$$$0(9);
        }
        boolean prohibitWidening = false;
        if (function instanceof JSFunctionExpression) {
            if (kind != JSExpectedTypeKind.CONTEXTUAL) {
                return returnType;
            }
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)function), JSExpectedTypeKind.WIDENING);
            if (expectedType instanceof JSFunctionTypeImpl && JSTypeUtils.containsLiteralTypes(((JSFunctionTypeImpl)expectedType).getReturnType())) {
                prohibitWidening = true;
            }
        }
        if (!prohibitWidening && (type = TypeScriptTypeRelations.expandAliasesRecursive(returnType)) instanceof JSUnionType && JSTypeUtils.containsLiteralTypes(type)) {
            prohibitWidening = true;
        }
        if (!prohibitWidening) {
            returnType = JSTypeUtils.getApparentType(returnType);
        }
        return returnType;
    }

    @Nullable
    private static JSType getActionScriptReturnTypeFromVector(@NotNull JSFunctionItem function, @Nullable PsiElement place, @Nullable JSType returnType) {
        String name;
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(10);
        }
        if (returnType instanceof JSAnyType && ("pop".equals(name = function.getName()) || "shift".equals(name))) {
            JSResolveUtil.GenericSignature signature;
            String qualifiedExpressionType;
            JSExpression instance;
            JSType classType;
            PsiElement element = JSResolveUtil.findParent((PsiElement)function);
            JSType jSType = classType = !(element instanceof JSClass) ? null : JSNamedTypeFactory.createType(Objects.requireNonNull(((JSClass)element).getQualifiedName()), JSTypeSource.EMPTY, JSContext.INSTANCE);
            if (classType != null && JSTypeUtils.isActionScriptVectorType(classType) && place instanceof JSReferenceExpression && (instance = ((JSReferenceExpression)place).getQualifier()) != null && (qualifiedExpressionType = JSResolveUtil.getQualifiedExpressionType(instance, place.getContainingFile())) != null && (signature = JSResolveUtil.extractGenericSignature(qualifiedExpressionType)) != null) {
                return JSTypeUtils.createType(signature.genericType, JSTypeSourceFactory.createTypeSource(place));
            }
        } else if (JSGenericTypeImpl.isGenericActionScriptVectorType(returnType) && place instanceof JSExpression) {
            JSExpression expression;
            JSExpression processedExpression = expression = (JSExpression)place;
            if (place instanceof JSReferenceExpression) {
                processedExpression = ((JSReferenceExpression)place).getQualifier();
            }
            if (processedExpression != null && processedExpression != expression) {
                String expressionType;
                JSExpression expressionToCheckType = processedExpression;
                PsiElement parent = processedExpression.getContext();
                if (parent instanceof JSCallExpression) {
                    expressionToCheckType = (JSExpression)parent;
                }
                if ((expressionType = JSResolveUtil.getQualifiedExpressionType(expressionToCheckType, expression.getContainingFile())) != null && (expressionType.equals("Vector") || expressionType.startsWith("Vector.<"))) {
                    return JSTypeUtils.createType(expressionType, JSTypeSourceFactory.createTypeSource(place));
                }
            }
        }
        return returnType;
    }

    @Nullable
    public static JSType evaluateReturnTypeFromHierarchy(@NotNull JSFunctionItem function) {
        JSType type;
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(11);
        }
        if ((type = function.getReturnType()) != null && type.getSource().isStrict()) {
            return type;
        }
        if (function.isOverride()) {
            Ref overridden = Ref.create(null);
            JSInheritanceUtil.processNearestOverriddenMethods(function, (Processor<? super JSFunction>)((Processor)function1 -> {
                overridden.set(function1);
                return function1 == null || function1.getReturnType() == null;
            }));
            if (!overridden.isNull()) {
                return ((JSFunction)overridden.get()).getReturnType();
            }
        }
        return type;
    }

    @Override
    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        if (parent instanceof JSClass) {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)this);
            if (dialect != null && dialect.isECMA6) {
                return Comparing.equal((String)"constructor", (String)this.getName(), (boolean)true);
            }
            return Comparing.equal((String)((JSClass)parent).getName(), (String)ActionScriptResolveUtil.replaceInternalName(this.getName()), (boolean)true);
        }
        return super.isConstructor();
    }

    @Override
    public boolean isOverride() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isOverride();
        }
        return super.isOverride();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSFunctionImpl.$$$reportNull$$$0(12);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFunctionDeclaration((JSFunction)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JSFunctionImpl.getFunctionIcon((JSFunctionItem)this, flags);
    }

    public static Icon getFunctionIcon(JSFunctionItem function, int flags) {
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        if (parent instanceof JSClass || parent instanceof JSPackageStatement) {
            JSAttributeList attributeList;
            JSAttributeList jSAttributeList = attributeList = function instanceof JSAttributeListOwner ? ((JSAttributeListOwner)function).getAttributeList() : null;
            if (attributeList != null && function instanceof JSFunction) {
                Icon initialIcon;
                JSFunction.FunctionKind kind = ((JSFunction)function).getKind();
                boolean isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                switch (kind) {
                    case GETTER: {
                        initialIcon = isStatic ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
                        break;
                    }
                    case SETTER: {
                        initialIcon = isStatic ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
                        break;
                    }
                    case CONSTRUCTOR: {
                        initialIcon = CONSTRUCTOR_ICON;
                        break;
                    }
                    case SIMPLE: {
                        initialIcon = PlatformIcons.METHOD_ICON;
                        break;
                    }
                    default: {
                        assert (false) : "unexpected kind: " + kind;
                        initialIcon = PlatformIcons.METHOD_ICON;
                    }
                }
                Icon baseIcon = JSFunctionImpl.blendModifierFlags(initialIcon, attributeList, kind == JSFunction.FunctionKind.SIMPLE);
                return JSFunctionImpl.iconWithVisibilityIfNeeded((int)flags, (Icon)baseIcon, (Icon)attributeList.getAccessType().getIcon());
            }
        }
        return JSFunctionImpl.getIcon((JSPsiElementBase)function, JSFunctionImpl.getFunctionBaseIcon(function), flags);
    }

    @NotNull
    public static Icon getFunctionBaseIcon(@NotNull JSFunctionItem function) {
        if (function == null) {
            JSFunctionImpl.$$$reportNull$$$0(13);
        }
        boolean isFunction = function.getNamespace() == null && function.isNamespaceExplicitlyDeclared();
        Icon icon = isFunction ? PlatformIcons.FUNCTION_ICON : PlatformIcons.METHOD_ICON;
        if (icon == null) {
            JSFunctionImpl.$$$reportNull$$$0(14);
        }
        return icon;
    }

    @Nullable
    public final JSQualifiedName getNamespace() {
        return this.getJSNamespace().getQualifiedName();
    }

    @Override
    @NotNull
    public final JSContext getJSContext() {
        JSContext jSContext = this.getJSNamespace().getJSContext();
        if (jSContext == null) {
            JSFunctionImpl.$$$reportNull$$$0(15);
        }
        return jSContext;
    }

    @Override
    public final boolean isNamespaceExplicitlyDeclared() {
        return this.getJSNamespace().isSourceStrict();
    }

    @Override
    @NotNull
    public final JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = (JSNamespace)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, NAMESPACE_PROVIDER_KEY, NAMESPACE_PROVIDER, false, (Object)this);
        if (jSNamespace == null) {
            JSFunctionImpl.$$$reportNull$$$0(16);
        }
        return jSNamespace;
    }

    @NotNull
    protected JSNamespace calculateSymbolNamespace() {
        PsiComment comment;
        PsiElement declarationScope;
        boolean isLocal;
        JSQualifiedName namespace;
        boolean useJSDocTypes = this.useTypesFromJSDoc();
        JSNamespace fromJSDoc = useJSDocTypes ? JSDocumentationUtils.getNamespaceFromJSDoc((JSNamedElement)this) : null;
        JSQualifiedName jSQualifiedName = namespace = fromJSDoc != null ? fromJSDoc.getQualifiedName() : null;
        if (fromJSDoc == null || !fromJSDoc.isSourceStrict()) {
            namespace = JSPsiImplUtils.getNamespace((JSNamedElement)this);
        }
        if ((isLocal = (declarationScope = PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSExecutionScope.class, JSClass.class})) instanceof JSFunction) && (comment = JSDocumentationUtils.findDocComment((PsiElement)this)) instanceof JSDocComment) {
            isLocal = !((JSDocComment)comment).isClassExplicitly() && ((JSDocComment)comment).getExplicitName() == null;
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(namespace, JSSymbolUtil.getContext(this, useJSDocTypes), (PsiElement)this, true, true, isLocal);
        if (jSNamespace == null) {
            JSFunctionImpl.$$$reportNull$$$0(17);
        }
        return jSNamespace;
    }

    @NotNull
    public SearchScope getUseScope() {
        if (this.isConstructor()) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                JSFunctionImpl.$$$reportNull$$$0(18);
            }
            return searchScope;
        }
        SearchScope searchScope = JSResolveUtil.findUseScope(this);
        if (searchScope == null) {
            JSFunctionImpl.$$$reportNull$$$0(19);
        }
        return searchScope;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement parentOriginalElement;
        PsiElement parent = this.getParent();
        if (parent instanceof JSClass && (parentOriginalElement = parent.getNavigationElement()) != parent) {
            JSFunction functionByNameAndKind = ((JSClass)parentOriginalElement).findFunctionByNameAndKind(this.getName(), this.getKind());
            Object object = functionByNameAndKind != null ? functionByNameAndKind : (this.isActionScriptDecompiledConstructor() ? parentOriginalElement : this);
            if (object == null) {
                JSFunctionImpl.$$$reportNull$$$0(20);
            }
            return object;
        }
        PsiElement psiElement = JSPsiImplUtils.findTopLevelNavigatableElement(this);
        if (psiElement == null) {
            JSFunctionImpl.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    private boolean isActionScriptDecompiledConstructor() {
        if (!this.isConstructor() || !DialectDetector.isActionScript((PsiElement)this)) {
            return false;
        }
        JSAttributeList attributeList = this.getAttributeList();
        if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.NATIVE)) {
            return false;
        }
        JSParameterList parameterList = this.getParameterList();
        if (parameterList == null || parameterList.getParameters().length != 0) {
            return false;
        }
        return "*".equals(this.getReturnTypeString());
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof JSVariable) {
            String name = ((JSVariable)another).getName();
            if (Comparing.equal((String)this.getName(), (String)name) && ActionScriptResolveUtil.fieldIsImplicitAccessorMethod(this, (JSVariable)another)) {
                return true;
            }
        }
        return super.isEquivalentTo(another);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionBaseIcon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateSymbolNamespace";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeInContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWidenReturnType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "widenMultiStatementReturnType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "subtypeReduction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "widenOneStatementReturnType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActionScriptReturnTypeFromVector";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "evaluateReturnTypeFromHierarchy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionBaseIcon";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$subtypeReduction$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

