/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSElementIterator;
import com.intellij.lang.javascript.psi.impl.JSFunctionVisitor;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindReferenceUtil {
    private FindReferenceUtil() {
    }

    public static <T extends PsiElement> T getFarthestAncestor(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        PsiElement currentElement;
        if (element == null) {
            FindReferenceUtil.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            FindReferenceUtil.$$$reportNull$$$0(1);
        }
        PsiElement previousElement = element;
        do {
            if (!aClass.isInstance(currentElement = previousElement.getParent())) {
                return (T)previousElement;
            }
            previousElement = currentElement;
        } while (currentElement != null);
        return null;
    }

    public static Iterable<PsiElement> getReferences(@NotNull JSVariable variable) {
        if (variable == null) {
            FindReferenceUtil.$$$reportNull$$$0(2);
        }
        return FindReferenceUtil.getReferences(variable, null, 0, Integer.MAX_VALUE);
    }

    public static Iterable<PsiElement> getReferences(@NotNull JSVariable variable, @Nullable PsiElement scope) {
        if (variable == null) {
            FindReferenceUtil.$$$reportNull$$$0(3);
        }
        return FindReferenceUtil.getReferences(variable, scope, 0, Integer.MAX_VALUE);
    }

    public static Iterable<PsiElement> getReferencesBefore(@NotNull JSVariable variable, int textOffset) {
        if (variable == null) {
            FindReferenceUtil.$$$reportNull$$$0(4);
        }
        return FindReferenceUtil.getReferences(variable, null, 0, textOffset);
    }

    public static Iterable<PsiElement> getReferencesAfter(@NotNull JSVariable variable, int textOffset) {
        if (variable == null) {
            FindReferenceUtil.$$$reportNull$$$0(5);
        }
        return FindReferenceUtil.getReferences(variable, null, textOffset, Integer.MAX_VALUE);
    }

    private static Iterable<PsiElement> getReferences(final @NotNull JSVariable variable, @Nullable PsiElement scope, final int minTextOffset, final int maxTextOffset) {
        PsiElement parent;
        JSElement function;
        if (variable == null) {
            FindReferenceUtil.$$$reportNull$$$0(6);
        }
        final Object iteratedScope = scope == null ? ((function = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSFunction.class)) == null ? ((parent = PsiTreeUtil.findFirstParent((PsiElement)variable, element -> JSUtils.isScopeOwner(element) || element instanceof PsiFile || element instanceof JSEmbeddedContent)) == null ? variable : parent) : function) : scope;
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new JSReferenceIterator(variable, minTextOffset, maxTextOffset, iteratedScope);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/FindReferenceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFarthestAncestor";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencesBefore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencesAfter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class JSReferenceIterator
    extends JSElementIterator {
        private final JSVariable variable;
        private final String variableName;

        public JSReferenceIterator(@NotNull JSVariable variable, int minTextOffset, int maxTextOffset, @NotNull PsiElement element) {
            if (variable == null) {
                JSReferenceIterator.$$$reportNull$$$0(0);
            }
            if (element == null) {
                JSReferenceIterator.$$$reportNull$$$0(1);
            }
            super(element, false, minTextOffset, maxTextOffset);
            this.variable = variable;
            this.variableName = variable.getName();
        }

        @Override
        public boolean visitElement(PsiElement element) {
            if (!element.getText().equals(this.variableName) || !(element instanceof JSReferenceExpression)) {
                return false;
            }
            JSVariable referent = ControlFlowUtils.resolveVariable((JSExpression)((JSReferenceExpression)element));
            return referent != null && this.variable.equals(referent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/impl/FindReferenceUtil$JSReferenceIterator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JSReferenceVisitor
    extends JSFunctionVisitor {
        private final JSVariable variable;
        private final String variableName;
        private final int maxCount;
        private final int minTextOffset;
        private final int maxTextOffset;
        private final List<JSReferenceExpression> references;

        JSReferenceVisitor(@NotNull JSVariable variable, int maxCount, int minTextOffset, int maxTextOffset) {
            if (variable == null) {
                JSReferenceVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
            this.variableName = variable.getName();
            this.maxCount = maxCount;
            this.minTextOffset = minTextOffset;
            this.maxTextOffset = maxTextOffset;
            this.references = new ArrayList<JSReferenceExpression>();
        }

        @Override
        public void visitElement(PsiElement element) {
            int elementTextOffset;
            if (this.references.size() < this.maxCount && (elementTextOffset = element.getTextOffset()) + element.getTextLength() >= this.minTextOffset && elementTextOffset <= this.maxTextOffset) {
                super.visitElement(element);
            }
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            JSVariable referent;
            super.visitJSReferenceExpression(expression);
            if (expression.getText().equals(this.variableName) && (referent = ControlFlowUtils.resolveVariable((JSExpression)expression)) != null && this.variable.equals(referent)) {
                this.references.add(expression);
            }
        }

        public JSReferenceExpression[] getReferences() {
            return this.references.toArray(new JSReferenceExpression[0]);
        }

        public JSReferenceExpression getReference(int index) {
            return index >= 0 && index < this.references.size() ? this.references.get(index) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil$JSReferenceVisitor", "<init>"));
        }
    }
}

