/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.inline.PhpInlineActionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpInlineVariableHandler
extends PhpInlineActionHandler {
    private static final Logger LOG = Logger.getInstance(PhpInlineVariableHandler.class);
    public static final String REFACTORING_NAME = "Inline variable";
    public static final String REFACTORING_HELP_ID = "refactoring.inlineVariable";
    public static final String FEATURE_ID = "refactoring.inlineVariable";
    private static final Comparator<TextRange> TEXT_RANGE_DESCEND_COMPARATOR = (o1, o2) -> o1.getStartOffset() > o2.getStartOffset() ? -1 : 1;

    public static boolean isClosedDoubleQuotedString(@NotNull StringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(0);
        }
        PsiElement lastChild = stringLiteralExpression.getLastChild();
        return PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.chRDOUBLE_QUOTE);
    }

    public static boolean isClosedHeredoc(@NotNull StringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(1);
        }
        PsiElement lastChild = stringLiteralExpression.getLastChild();
        return PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.HEREDOC_END);
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof Variable && ((Variable)element).canReadName() || element instanceof Parameter;
    }

    public void inlineElement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(4);
        }
        try {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.inlineVariable");
            PhpInlineVariableHandler.invoke(project, editor);
        }
        catch (PhpRefactoringErrorException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)e.getMessage()), (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
        }
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor) throws PhpRefactoringErrorException {
        PsiReference psiReference;
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(6);
        }
        if (!((psiReference = TargetElementUtil.findReference((Editor)editor)) instanceof Variable)) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.cannot.find.variable.to.inline", new Object[0]));
        }
        PhpInlineVariableHandler.invoke(project, editor, (Variable)psiReference);
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull Variable variable) throws PhpRefactoringErrorException {
        PhpScopeHolder scopeHolder;
        CharSequence variableName;
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(8);
        }
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(9);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        if ((variableName = variable.getNameCS()).length() == 0) {
            return;
        }
        PhpAccessVariableInstruction accessVariableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (accessVariableInstruction == null) {
            return;
        }
        List<PhpAccessVariableInstruction> latestWriteAccesses = PhpInlineVariableHandler.getLatestVariableWriteAccess(accessVariableInstruction);
        if (latestWriteAccesses.size() != 1) {
            throw new PhpRefactoringErrorException(RefactoringBundle.message((String)"variable.has.no.dominating.definition"));
        }
        PhpAccessVariableInstruction latestWriteAccess = latestWriteAccesses.get(0);
        Ref initializerRef = new Ref();
        Ref valueRef = new Ref();
        PhpPsiElement writeVariable = latestWriteAccess.getAnchor();
        PsiElement parent = writeVariable.getParent();
        PhpAccessInstruction.Access access = latestWriteAccess.getAccess();
        if (access.isReadRef() || access.isReadWrite() || access.isWriteRef()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
        }
        if (parent instanceof AssignmentExpression) {
            if (PhpElementTypes.MULTIASSIGNMENT_EXPRESSION == parent.getNode().getElementType()) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
            }
            valueRef.set((Object)((AssignmentExpression)parent).getValue());
            initializerRef.set((Object)((AssignmentExpression)parent));
        }
        if (valueRef.isNull()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
        }
        List<PhpAccessVariableInstruction> followingReadAccesses = PhpInlineVariableHandler.getFollowingVariableReadAccess(latestWriteAccess);
        int readAccessSizeBeforeFiltering = followingReadAccesses.size();
        for (int i = followingReadAccesses.size() - 1; i >= 0; --i) {
            PhpAccessVariableInstruction readAccess = followingReadAccesses.get(i);
            if (!PhpInlineVariableHandler.isPossibleToInline(readAccess, (PsiElement)valueRef.get())) {
                followingReadAccesses.remove(i);
                continue;
            }
            List<PhpAccessVariableInstruction> writeAccesses = PhpInlineVariableHandler.getLatestVariableWriteAccess(readAccess);
            if (writeAccesses.size() == 1) continue;
            followingReadAccesses.remove(i);
        }
        if (accessVariableInstruction == latestWriteAccess) {
            if (followingReadAccesses.size() == 0) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.no.occurrences", new Object[0]));
            }
        } else if (!followingReadAccesses.contains(accessVariableInstruction)) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.no.occurrences", variableName));
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        TextAttributes writeAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        TextAttributes readAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{latestWriteAccess.getAnchor()}, writeAttributes, true, null);
            Variable[] occurrences = new Variable[followingReadAccesses.size()];
            for (int i = 0; i < followingReadAccesses.size(); ++i) {
                occurrences[i] = followingReadAccesses.get(i).getAnchor();
            }
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])occurrences, readAttributes, true, null);
            String promptKey = "inline.local.variable.prompt";
            String question = RefactoringBundle.message((String)"inline.local.variable.prompt", (Object[])new Object[]{variableName}) + " " + RefactoringBundle.message((String)"occurrences.string", (Object[])new Object[]{occurrences.length});
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(REFACTORING_NAME, question, "refactoring.inlineVariable", "OptionPane.questionIcon", true, project);
            if (!dialog.showAndGet()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                return;
            }
        }
        boolean deleteInitializer = (scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable)) != null && !PhpControlFlowUtil.isReferenced(scopeHolder, latestWriteAccess) && readAccessSizeBeforeFiltering == followingReadAccesses.size();
        MultiMap variablesInString = new MultiMap();
        for (int i = followingReadAccesses.size() - 1; i >= 0; --i) {
            PhpAccessVariableInstruction readAccess = followingReadAccesses.get(i);
            PhpPsiElement anchor = readAccess.getAnchor();
            if (!(anchor.getParent() instanceof StringLiteralExpression)) continue;
            followingReadAccesses.remove(i);
            variablesInString.putValue((Object)((StringLiteralExpression)anchor.getParent()), (Object)((Variable)anchor));
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                PhpInlineVariableHandler.$$$reportNull$$$0(26);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    PhpInlineVariableHandler.$$$reportNull$$$0(27);
                }
                for (PhpAccessVariableInstruction readAccess : followingReadAccesses) {
                    PsiElement expression;
                    PhpPsiElement anchor = readAccess.getAnchor();
                    if (PhpInlineVariableHandler.isNecessaryToParenthesize(anchor, expression = (PsiElement)valueRef.get())) {
                        String parenthesizedText = "(" + expression.getText() + ")";
                        ParenthesizedExpression newElement = PhpPsiElementFactory.createPhpPsiFromText(project, ParenthesizedExpression.class, parenthesizedText);
                        PhpCodeEditUtil.replace((PsiElement)anchor, (PhpExpression)newElement);
                    }
                    PhpCodeEditUtil.replace((PsiElement)anchor, (PhpExpression)expression);
                }
                for (StringLiteralExpression literalExpression : variablesInString.keySet()) {
                    PhpInlineVariableHandler.replaceVariableInString(literalExpression, variablesInString.get((Object)literalExpression), (PsiElement)valueRef.get());
                }
                if (deleteInitializer) {
                    PhpCodeEditUtil.deleteExpression((PhpExpression)initializerRef.get());
                }
            });
        }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{variableName}), null);
    }

    private static boolean isPossibleToInline(@NotNull PhpAccessVariableInstruction instruction, @NotNull PsiElement value) {
        IElementType variableParentType;
        PhpPsiElement anchor;
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(10);
        }
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(11);
        }
        if (!((anchor = instruction.getAnchor()) instanceof Variable)) {
            return false;
        }
        if (instruction.getAccess().isLightRead()) {
            return false;
        }
        PsiElement variableParent = anchor.getParent();
        if (variableParent instanceof Variable || variableParent instanceof PhpUseList) {
            return false;
        }
        Object parentString = PhpPsiUtil.getParentByCondition(variableParent, false, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
        if (parentString instanceof StringLiteralExpression) {
            IElementType parentType = parentString.getNode().getElementType();
            if (PhpElementTypes.HEREDOC.equals(parentType) && PhpInlineVariableHandler.isClosedHeredoc((StringLiteralExpression)parentString) || PhpElementTypes.STRING.equals(parentType) && PhpInlineVariableHandler.isClosedDoubleQuotedString((StringLiteralExpression)parentString)) {
                if (value instanceof StringLiteralExpression) {
                    return value.getChildren().length == 0;
                }
                return false;
            }
            return false;
        }
        if (variableParent instanceof MemberReference) {
            if (((MemberReference)variableParent).getClassReference() != anchor || value instanceof StringLiteralExpression) {
                return false;
            }
        } else {
            if (variableParent instanceof FunctionReference) {
                return false;
            }
            if (variableParent instanceof ClassReference) {
                return false;
            }
            if (variableParent instanceof AssignmentExpression) {
                return !PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)variableParent);
            }
        }
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(variableParentType = variableParent.getNode().getElementType())) {
            return value instanceof Variable;
        }
        return true;
    }

    private static boolean isNecessaryToParenthesize(@NotNull PhpPsiElement variable, @NotNull PsiElement targetExpression) {
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(12);
        }
        if (targetExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(13);
        }
        if (targetExpression instanceof NewExpression && !(targetExpression.getParent() instanceof ParenthesizedExpression)) {
            return variable.getParent() instanceof MemberReference;
        }
        return false;
    }

    @NotNull
    private static PsiElement replaceVariableInString(@NotNull StringLiteralExpression stringLiteral, @NotNull Collection<Variable> variables, @NotNull PsiElement value) {
        if (stringLiteral == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(14);
        }
        if (variables == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(15);
        }
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(16);
        }
        ASTNode parentNode = stringLiteral.getNode();
        IElementType parentType = parentNode.getElementType();
        String parentText = stringLiteral.getText();
        int parentStartOffset = stringLiteral.getTextRange().getStartOffset();
        String stringValue = PhpCodeInsightUtil.toString(value);
        ArrayList<TextRange> ranges = new ArrayList<TextRange>(variables.size());
        if (PhpElementTypes.HEREDOC.equals(parentType)) {
            PhpInlineVariableHandler.appendVariableRanges(variables, ranges, PhpTokenTypes.HEREDOC_CONTENTS, PhpTokenTypes.HEREDOC_START, PhpTokenTypes.HEREDOC_END);
        } else if (PhpElementTypes.STRING.equals(parentType)) {
            PhpInlineVariableHandler.appendVariableRanges(variables, ranges, PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.chLDOUBLE_QUOTE, PhpTokenTypes.chRDOUBLE_QUOTE);
        } else {
            LOG.error("StringLiteralExpression can be STRING or HEREDOC only");
            if (null == null) {
                PhpInlineVariableHandler.$$$reportNull$$$0(17);
            }
            return null;
        }
        ContainerUtil.sort(ranges, TEXT_RANGE_DESCEND_COMPARATOR);
        StringBuilder builder = new StringBuilder(parentText);
        for (TextRange range : ranges) {
            builder.replace(range.getStartOffset() - parentStartOffset, range.getEndOffset() - parentStartOffset, stringValue);
        }
        StringLiteralExpression newStringLiteral = PhpPsiElementFactory.createPhpPsiFromText(stringLiteral.getProject(), StringLiteralExpression.class, builder.toString());
        PsiElement psiElement = stringLiteral.replace((PsiElement)newStringLiteral);
        if (psiElement == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(18);
        }
        return psiElement;
    }

    private static void appendVariableRanges(@NotNull Collection<Variable> variables, @NotNull List<TextRange> ranges, @NotNull IElementType contentType, @NotNull IElementType start, @NotNull IElementType end) {
        if (variables == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(19);
        }
        if (ranges == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(20);
        }
        if (contentType == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(21);
        }
        if (start == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(22);
        }
        if (end == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(23);
        }
        for (Variable variable : variables) {
            PsiElement endRangeSibling = PhpPsiUtil.findNextSiblingOfAnyType((PsiElement)variable, contentType, end);
            PsiElement beginRangeSibling = PhpPsiUtil.findPrevSiblingOfAnyType((PsiElement)variable, contentType, start);
            assert (beginRangeSibling != null) : "Can not find next element for " + variable.getTextRange() + "at " + variable.getParent().getText();
            assert (endRangeSibling != null) : "Can not find prev element for " + variable.getTextRange() + "at " + variable.getParent().getText();
            ranges.add(new TextRange(beginRangeSibling.getTextRange().getEndOffset(), endRangeSibling.getTextRange().getStartOffset()));
        }
    }

    private static List<PhpAccessVariableInstruction> getLatestVariableWriteAccess(@NotNull PhpAccessVariableInstruction instruction) {
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(24);
        }
        final CharSequence variableName = instruction.getVariableName();
        final ArrayList<PhpAccessVariableInstruction> latestWriteAccess = new ArrayList<PhpAccessVariableInstruction>();
        final Ref isEntryPointReached = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, true, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName()) && (access.isWrite() || access.isWriteRef() || access.isReadWrite() || access.isReadRef())) {
                    latestWriteAccess.add(instruction);
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                isEntryPointReached.set((Object)true);
                return false;
            }
        });
        if (latestWriteAccess.size() == 0 || ((Boolean)isEntryPointReached.get()).booleanValue()) {
            return Collections.emptyList();
        }
        return latestWriteAccess;
    }

    private static List<PhpAccessVariableInstruction> getFollowingVariableReadAccess(@NotNull PhpAccessVariableInstruction instruction) {
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(25);
        }
        final CharSequence variableName = instruction.getVariableName();
        final ArrayList<PhpAccessVariableInstruction> followingReadAccess = new ArrayList<PhpAccessVariableInstruction>();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement accessedVariable = instruction.getAnchor();
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    if (!(instruction.getAccess().isWrite() || instruction.getAccess().isWriteRef() || instruction.getAccess().isReadRef())) {
                        followingReadAccess.add(instruction);
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
        if (followingReadAccess.size() == 0) {
            return Collections.emptyList();
        }
        return followingReadAccess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteralExpression";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 10: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/inline/PhpInlineVariableHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/inline/PhpInlineVariableHandler";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceVariableInString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClosedDoubleQuotedString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isClosedHeredoc";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inlineElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleToInline";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNecessaryToParenthesize";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceVariableInString";
                break;
            }
            case 17: 
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableRanges";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLatestVariableWriteAccess";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingVariableReadAccess";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$2";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

