/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpRedundantClosingTagInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "PhpRemoveClosingTagQuickFix", "intellij.php.impl"})
public final class PhpRedundantClosingTagInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitPhpFile(@NotNull PhpFile phpFile) {
                Intrinsics.checkParameterIsNotNull((Object)phpFile, (String)"phpFile");
                PsiFile psiFile = phpFile.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE);
                if (!(psiFile instanceof HtmlFileImpl)) {
                    psiFile = null;
                }
                HtmlFileImpl htmlFileImpl = (HtmlFileImpl)psiFile;
                if (htmlFileImpl == null) {
                    return;
                }
                HtmlFileImpl htmlFile = htmlFileImpl;
                PsiElement php = null;
                XmlDocument xmlDocument = htmlFile.getDocument();
                if (xmlDocument == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlDocument, (String)"htmlFile.document ?: return");
                XmlDocument document = xmlDocument;
                for (PsiElement child : document.getChildren()) {
                    if (PhpPsiUtil.isOfType(child, PhpElementTypes.PHP_OUTER_TYPE)) {
                        if (php != null) {
                            return;
                        }
                        php = child;
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(child, XmlElementType.XML_PROLOG) || PhpAnnotatorVisitor.isShebang(child)) continue;
                    return;
                }
                if (php == null) {
                    PsiElement next = document.getNextSibling();
                    if (next == null || !PhpPsiUtil.isOfType(next, PhpElementTypes.PHP_OUTER_TYPE)) {
                        return;
                    }
                    php = next;
                }
                GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)phpFile, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                if (groupStatement == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)groupStatement, (String)"PhpPsiUtil.getChildByCon\u2026ent.INSTANCEOF) ?: return");
                GroupStatement statement = groupStatement;
                PhpNamespace namespace = (PhpNamespace)PhpPsiUtil.getChildByCondition((PsiElement)statement, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
                if (namespace != null && !namespace.isBraced()) {
                    T t = PhpPsiUtil.getChildByCondition((PsiElement)namespace, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    statement = (GroupStatement)t;
                }
                if (statement.getLastChild() == null) {
                    return;
                }
                for (PsiElement lastChild = v241707; lastChild != null; lastChild = lastChild.getPrevSibling()) {
                    PsiElement firstOpeningTag;
                    if (!PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.PHP_CLOSING_TAG) || !Intrinsics.areEqual((Object)"?>", (Object)lastChild.getText())) continue;
                    PsiElement openingTag = null;
                    if (namespace != null && !namespace.isBraced()) {
                        openingTag = PhpPsiUtil.findPrevSiblingOfAnyType((PsiElement)namespace, PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG);
                    }
                    if (openingTag == null) {
                        openingTag = PhpPsiUtil.findPrevSiblingOfAnyType(lastChild, PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG);
                    }
                    if (Intrinsics.areEqual((Object)openingTag, (Object)(firstOpeningTag = phpFile.findElementAt(php.getTextOffset()))) && PhpPsiUtil.isOfType(openingTag, PhpTokenTypes.PHP_OPENING_TAG)) {
                        this.$holder.registerProblem(lastChild, PhpBundle.message("inspection.redundant.closing.tag.problem", new Object[0]), new LocalQuickFix[]{PhpRemoveClosingTagQuickFix.INSTANCE});
                    }
                    return;
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpRedundantClosingTagInspection$PhpRemoveClosingTagQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.php.impl"})
    private static final class PhpRemoveClosingTagQuickFix
    implements LocalQuickFix {
        public static final PhpRemoveClosingTagQuickFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.redundant.closing.tag.fix.remove", new Object[0]);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            descriptor.getPsiElement().delete();
        }

        private PhpRemoveClosingTagQuickFix() {
        }

        static {
            PhpRemoveClosingTagQuickFix phpRemoveClosingTagQuickFix;
            INSTANCE = phpRemoveClosingTagQuickFix = new PhpRemoveClosingTagQuickFix();
        }
    }
}

