/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpConstFormatPreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement psiElement;
        if (element == null) {
            PhpConstFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PhpConstFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null || !psiElement.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpConstFormatPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (!psiElement.getLanguage().is((Language)PhpLanguage.INSTANCE)) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpConstFormatPreprocessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        TextRange textRange = new PhpConstFormatter(psiElement).process(range);
        if (textRange == null) {
            PhpConstFormatPreprocessor.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpConstFormatPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpConstFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpConstFormatter
    extends PhpElementVisitor {
        private Project myProject;
        private TextRange myRange;
        private Document myDocument;
        private PsiElement myElement;
        private PsiDocumentManager myDocumentManager;
        private PhpCodeStyleSettings myPhpCodeStyleSettings;

        private PhpConstFormatter(@NotNull PsiElement element) {
            if (element == null) {
                PhpConstFormatter.$$$reportNull$$$0(0);
            }
            try {
                this.myProject = element.getProject();
                this.myElement = element;
                PsiFile file = element.getContainingFile();
                if (file != null) {
                    this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                    this.myDocument = file.isPhysical() ? this.myDocumentManager.getDocument(file) : file.getViewProvider().getDocument();
                    this.myPhpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
                }
            }
            catch (PsiInvalidElementAccessException e) {
                this.myProject = null;
            }
        }

        public TextRange process(TextRange range) {
            if (this.myProject == null) {
                return range;
            }
            if (this.myDocument == null || !this.myPhpCodeStyleSettings.UPPER_CASE_BOOLEAN_CONST && !this.myPhpCodeStyleSettings.UPPER_CASE_NULL_CONST && !this.myPhpCodeStyleSettings.LOWER_CASE_BOOLEAN_CONST && !this.myPhpCodeStyleSettings.LOWER_CASE_NULL_CONST) {
                return range;
            }
            this.myRange = new TextRange(range.getStartOffset(), range.getEndOffset());
            this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
            this.getElementToVisit().accept((PsiElementVisitor)this);
            this.myDocumentManager.commitDocument(this.myDocument);
            return this.myRange;
        }

        @NotNull
        private PsiElement getElementToVisit() {
            PsiElement curr = this.myElement;
            for (PsiElement parent = this.myElement.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
                if (curr instanceof PsiFile || !parent.getTextRange().equals((Object)this.myElement.getTextRange())) {
                    PsiElement psiElement = curr;
                    if (psiElement == null) {
                        PhpConstFormatter.$$$reportNull$$$0(1);
                    }
                    return psiElement;
                }
                curr = parent;
            }
            PsiElement psiElement = curr;
            if (psiElement == null) {
                PhpConstFormatter.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        public void visitPhpConstantReference(ConstantReference reference) {
            TextRange constRange;
            super.visitPhpConstantReference(reference);
            PsiElement child = reference.getFirstChild();
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.IDENTIFIER) && this.myRange.contains(constRange = child.getTextRange())) {
                String constText = child.getText();
                String replacementText = null;
                if ("true".equalsIgnoreCase(constText) || "false".equalsIgnoreCase(constText)) {
                    if (this.myPhpCodeStyleSettings.UPPER_CASE_BOOLEAN_CONST) {
                        replacementText = constText.toUpperCase();
                    } else if (this.myPhpCodeStyleSettings.LOWER_CASE_BOOLEAN_CONST) {
                        replacementText = constText.toLowerCase();
                    }
                } else if ("null".equalsIgnoreCase(constText)) {
                    if (this.myPhpCodeStyleSettings.UPPER_CASE_NULL_CONST) {
                        replacementText = constText.toUpperCase();
                    } else if (this.myPhpCodeStyleSettings.LOWER_CASE_NULL_CONST) {
                        replacementText = constText.toLowerCase();
                    }
                }
                if (replacementText != null) {
                    this.myDocument.replaceString(constRange.getStartOffset(), constRange.getEndOffset(), (CharSequence)replacementText);
                }
            }
        }

        public void visitElement(PsiElement element) {
            element.acceptChildren((PsiElementVisitor)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpConstFormatPreprocessor$PhpConstFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpConstFormatPreprocessor$PhpConstFormatter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementToVisit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

