/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCustomFormatFunctionsChooserForm {
    private final TextFieldWithCompletion myFunctionTextField;
    private final TextFieldWithCompletion myClassTextField;
    private final Validator myValidator;
    private JPanel myPanel;
    private JBLabel myFunctionFqnLabel;
    private JBTextField myFormatParameterIndexTextField;
    private JPanel myClassFqnTextFieldWrapperPanel;
    private JPanel myFunctionTextFieldWrapperPanel;

    public JPanel getPanel() {
        return this.myPanel;
    }

    public PhpCustomFormatFunctionsChooserForm(Project project, Disposable disposable) {
        this.$$$setupUI$$$();
        this.myValidator = new Validator(this);
        this.myFunctionTextField = this.createFunctionTextField(project, disposable);
        this.myFunctionTextFieldWrapperPanel.add((Component)this.myFunctionTextField);
        this.myClassTextField = this.createClassTextField(project, disposable);
        this.myClassFqnTextFieldWrapperPanel.add((Component)this.myClassTextField);
        new ComponentValidator((Disposable)project).withValidator(v -> v.updateInfo(this.myValidator.validateFormatIndex())).installOn((JComponent)this.myFormatParameterIndexTextField);
        this.myFormatParameterIndexTextField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance((JComponent)PhpCustomFormatFunctionsChooserForm.this.myFormatParameterIndexTextField).ifPresent(v -> v.revalidate());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm$1", "textChanged"));
            }
        });
    }

    private Stream<PhpClass> selectedClasses(PhpIndex index) {
        return index.getAnyByFQN(this.myClassTextField.getText()).stream().filter(c -> !c.isInterface());
    }

    @Nullable
    public ValidationInfo validate(@NotNull PhpIndex index) {
        if (index == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(0);
        }
        return this.myValidator.validate(index);
    }

    @NotNull
    private TextFieldWithCompletion createClassTextField(Project project, Disposable disposable) {
        final PhpIndex index = PhpIndex.getInstance((Project)project);
        final TextFieldWithCompletion field = new TextFieldWithCompletion(project, (TextCompletionProvider)new PhpCompletionUtil.PhpFullyQualifiedNameTextFieldCompletionProvider(){

            @Override
            protected void addCompletionVariants(@NotNull String namespaceName, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (namespaceName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                PhpCustomFormatFunctionsChooserForm.this.suggestClasses(namespaceName, prefix, result, index);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespaceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm$2";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "", true, true, false);
        PhpCompletionUtil.installAutoCompletionAfterNamespaceSeparator((EditorTextField)field, disposable);
        field.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                PhpCustomFormatFunctionsChooserForm.this.myFunctionFqnLabel.setText(field.getText().isEmpty() ? "Function FQN" : "Method name");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm$3", "documentChanged"));
            }
        });
        field.setPlaceholder((CharSequence)PhpBundle.message("custom.format.functions.dialog.class.placeholder", new Object[0]));
        field.setText("");
        TextFieldWithCompletion textFieldWithCompletion = field;
        if (textFieldWithCompletion == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(1);
        }
        return textFieldWithCompletion;
    }

    @NotNull
    private TextFieldWithCompletion createFunctionTextField(final Project project, Disposable disposable) {
        final PhpIndex index = PhpIndex.getInstance((Project)project);
        TextFieldWithCompletion field = new TextFieldWithCompletion(project, (TextCompletionProvider)new PhpCompletionUtil.PhpFullyQualifiedNameTextFieldCompletionProvider(){

            @Override
            protected void addCompletionVariants(@NotNull String namespaceName, @NotNull String prefix, @NotNull CompletionResultSet result) {
                String classFqn;
                if (namespaceName == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (!(classFqn = PhpCustomFormatFunctionsChooserForm.this.myClassTextField.getText()).isEmpty()) {
                    PhpCustomFormatFunctionsChooserForm.suggestMethodsForSelectedClass(project, index, result, classFqn);
                } else {
                    PhpCustomFormatFunctionsChooserForm.this.suggestFunctions(result, index, namespaceName, prefix);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespaceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm$4";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "", true, true, false);
        PhpCompletionUtil.installAutoCompletionAfterNamespaceSeparator((EditorTextField)field, disposable);
        TextFieldWithCompletion textFieldWithCompletion = field;
        if (textFieldWithCompletion == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(2);
        }
        return textFieldWithCompletion;
    }

    private void suggestFunctions(@NotNull CompletionResultSet result, PhpIndex index, @NotNull String namespaceName, @NotNull String prefix) {
        if (result == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(3);
        }
        if (namespaceName == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(5);
        }
        String namespace = PhpLangUtil.toFQN(namespaceName);
        index.getAllFunctionNames((PrefixMatcher)new CamelHumpMatcher(prefix)).stream().flatMap(name -> index.getFunctionsByName(name).stream()).filter(e -> {
            if (namespaceName == null) {
                PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(11);
            }
            return namespaceName.isEmpty() || PhpCompletionUtil.hasNamespace((PhpNamedElement)e, namespace);
        }).map(namedElement -> PhpCustomFormatFunctionsChooserForm.createLookupElement((PhpNamedElement)namedElement, this.myFunctionTextField)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        PhpCompletionUtil.addSubNamespaces(namespaceName, result, index);
    }

    private void suggestClasses(String namespaceName, String prefix, CompletionResultSet result, PhpIndex index) {
        String namespace = PhpLangUtil.toFQN(namespaceName);
        Predicate<PhpClass> predicate = clazz -> !clazz.isInterface() && (namespaceName.isEmpty() || PhpCompletionUtil.hasNamespace((PhpNamedElement)clazz, namespace));
        PhpCompletionUtil.addClasses(index, (PrefixMatcher)new CamelHumpMatcher(prefix), predicate, c -> result.addElement((LookupElement)PhpCustomFormatFunctionsChooserForm.createLookupElement((PhpNamedElement)c, this.myClassTextField)));
    }

    public void setClassFqn(String value) {
        this.myClassTextField.setText(value);
    }

    public void setFunctionFqn(String value) {
        this.myFunctionTextField.setText(value);
    }

    public void setFormatParameterIndex(int value) {
        this.myFormatParameterIndexTextField.setText(String.valueOf(value));
    }

    @NotNull
    private static PhpLookupElement createLookupElement(final PhpNamedElement namedElement, final TextFieldWithCompletion textField) {
        PhpLookupElement phpLookupElement = new PhpLookupElement(namedElement){

            @Override
            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    5.$$$reportNull$$$0(0);
                }
                textField.setText(namedElement.getFQN());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm$5", "handleInsert"));
            }
        };
        if (phpLookupElement == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(6);
        }
        return phpLookupElement;
    }

    @NotNull
    public String getClassFqn() {
        String string = this.myClassTextField.getText();
        if (string == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFunctionText() {
        String string = this.myFunctionTextField.getText();
        if (string == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getFormatIndexText() {
        String string = this.myFormatParameterIndexTextField.getText();
        if (string == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static void suggestMethodsForSelectedClass(Project project, PhpIndex index, @NotNull CompletionResultSet result, String classText) {
        PhpClass selectedClass;
        if (result == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(10);
        }
        PhpClass phpClass = selectedClass = !DumbService.getInstance((Project)project).isDumb() ? (PhpClass)ContainerUtil.getFirstItem((Collection)index.getAnyByFQN(classText)) : null;
        if (selectedClass != null) {
            for (Method method : selectedClass.getOwnMethods()) {
                result.addElement((LookupElement)new PhpLookupElement((PhpNamedElement)method));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassTextField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionTextField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatIndexText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suggestFunctions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestMethodsForSelectedClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestFunctions$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(10);
        jBLabel2.setText("Class FQN");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClassFqnTextFieldWrapperPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFunctionFqnLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFunctionTextFieldWrapperPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/PhpBundle").getString("custom.format.functions.dialog.format.index.title"));
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFormatParameterIndexTextField = jBTextField = new JBTextField();
        jBTextField.setText("0");
        jPanel6.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static class Validator {
        private final PhpCustomFormatFunctionsChooserForm myForm;

        public Validator(PhpCustomFormatFunctionsChooserForm myPhpCustomFormatFunctionsChooserForm) {
            this.myForm = myPhpCustomFormatFunctionsChooserForm;
        }

        @Nullable
        public ValidationInfo validate(@NotNull PhpIndex index) {
            ValidationInfo formatIndexValidation;
            if (index == null) {
                Validator.$$$reportNull$$$0(0);
            }
            if ((formatIndexValidation = this.validateFormatIndex()) != null) {
                return formatIndexValidation;
            }
            ValidationInfo classTextValidation = this.validateClassText(index);
            if (classTextValidation != null) {
                return classTextValidation;
            }
            ValidationInfo functionTextValidation = this.validateFunctionText(index);
            if (functionTextValidation != null) {
                return functionTextValidation;
            }
            return null;
        }

        private ValidationInfo validateClassText(PhpIndex index) {
            String text = this.myForm.myClassTextField.getText();
            if (!text.isEmpty() && !this.myForm.selectedClasses(index).findAny().isPresent()) {
                return new ValidationInfo(PhpBundle.message("custom.format.functions.dialog.validation.class.not.found", text), (JComponent)this.myForm.myClassTextField);
            }
            return null;
        }

        private ValidationInfo validateFormatIndex() {
            if (!XdebugUtil.isInteger(this.myForm.getFormatIndexText())) {
                return new ValidationInfo(PhpBundle.message("custom.format.functions.dialog.validation.format.index", new Object[0]), (JComponent)this.myForm.myFormatParameterIndexTextField);
            }
            return null;
        }

        @Nullable
        private ValidationInfo validateFunctionText(PhpIndex myIndex) {
            String classFqn = this.myForm.getClassFqn();
            String functionText = this.myForm.getFunctionText();
            if (!classFqn.isEmpty()) {
                if (this.myForm.selectedClasses(myIndex).noneMatch(c -> c.findMethodByName((CharSequence)functionText) != null)) {
                    return new ValidationInfo(PhpBundle.message("custom.format.functions.dialog.validation.method.not.found", functionText, PhpLangUtil.toShortName(classFqn)), (JComponent)this.myForm.myFunctionTextField);
                }
            } else if (myIndex.getFunctionsByFQN(functionText).isEmpty()) {
                return new ValidationInfo(PhpBundle.message("custom.format.functions.dialog.validation.function.not.found", functionText), (JComponent)this.myForm.myFunctionTextField);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm$Validator", "validate"));
        }
    }
}

