/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.addDependency;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerPackagedVersionedCommandExecutor;
import com.jetbrains.php.composer.ComposerRunningData;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.addDependency.AddDependencyForm;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDependencyDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AddDependencyDialog.class);
    private static final String PLACE = "AddDependencyDialog";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myComposerJson;
    private JPanel myMainPanel;
    private AddDependencyForm myForm;
    private HoverHyperlinkLabel myInstallationFeedbackLinkLabel;
    private JBLabel myInstallationFeedbackLabel;
    private RawCommandLineEditor myCommandLineParametersEditor;
    private HyperlinkListener myHyperlinkListener;
    private JButton myCloseButton;
    private Runnable myChangesListener;
    private RemoveAction myRemoveAction;

    public AddDependencyDialog(@NotNull Project project, @NotNull VirtualFile composerJson, @NotNull List<InstalledPackageData> installedPackages) {
        if (project == null) {
            AddDependencyDialog.$$$reportNull$$$0(0);
        }
        if (composerJson == null) {
            AddDependencyDialog.$$$reportNull$$$0(1);
        }
        if (installedPackages == null) {
            AddDependencyDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myComposerJson = composerJson;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(PhpBundle.message("framework.composer.add.composer.dependency.title", objectArray));
        this.myInstallationFeedbackLabel.setVisible(false);
        this.myInstallationFeedbackLinkLabel.setVisible(false);
        for (InstalledPackageData installedPackage : installedPackages) {
            this.myForm.addInstalledPackage(installedPackage.getName(), installedPackage.getVersion());
        }
        String commandLineOptions = ComposerOptionsManager.getCommandLineOptions(project, ComposerOptionsManager.Command.ADD_DEPENDENCY, this.myComposerJson.getParent());
        this.myCommandLineParametersEditor.setText(commandLineOptions);
        this.init();
        this.pack();
        this.initValidation();
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myRemoveAction = new RemoveAction();
        this.myRemoveAction.setEnabled(false);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.myRemoveAction, this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            AddDependencyDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    private void createUIComponents() {
        this.myInstallationFeedbackLinkLabel = new HoverHyperlinkLabel("");
        this.setOKActionEnabled(false);
        this.setOKButtonText(PhpBundle.message("framework.composer.add.dependency.install.button", new Object[0]));
        this.setOKButtonMnemonic(73);
        this.setCancelButtonText(PhpBundle.message("framework.composer.add.dependency.close.button", new Object[0]));
        this.myChangesListener = () -> {
            this.setOKActionEnabled(this.myForm.validate() == null);
            boolean packageInstalled = this.myForm.isSelectedPackageInstalled();
            if (packageInstalled) {
                this.setOKButtonText(PhpBundle.message("framework.composer.add.dependency.update.button", new Object[0]));
                this.setOKButtonMnemonic(85);
                this.myRemoveAction.setEnabled(true);
            } else {
                this.setOKButtonText(PhpBundle.message("framework.composer.add.dependency.install.button", new Object[0]));
                this.setOKButtonMnemonic(73);
                this.myRemoveAction.setEnabled(false);
            }
        };
        this.myForm = new AddDependencyForm(false, false, this.myChangesListener, false);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validate = this.myForm.validate();
        if (validate != null) {
            return new ValidationInfo(validate.message, null);
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "PHPComposerAddDependencyDialogDimensionKey";
    }

    protected void doOKAction() {
        ComposerPackage aPackage = this.myForm.getSelectedPackage();
        LOG.assertTrue(aPackage != null);
        String commandLineOptions = this.myCommandLineParametersEditor.getText();
        if (this.myForm.isSelectedPackageInstalled()) {
            AddDependencyDialog.createUpdatingExecutor(aPackage.getName(), commandLineOptions, ComposerDataService.getInstance(this.myProject), this, this.myProject, this.myComposerJson, PLACE).execute();
        } else {
            Object selectedValue = this.myForm.getVersionComboBox().getSelectedItem();
            String version = selectedValue instanceof String ? (String)selectedValue : StringUtil.notNullize((String)((String)this.myForm.getVersionComboBox().getItemAt(0)));
            if (commandLineOptions != null) {
                commandLineOptions = commandLineOptions.trim();
            }
            ComposerOptionsManager.setCommandLineOptions(this.myProject, ComposerOptionsManager.Command.ADD_DEPENDENCY, this.myComposerJson.getParent(), commandLineOptions);
            AddDependencyDialog.createInstallingExecutor(aPackage.getName(), version, commandLineOptions, ComposerDataService.getInstance(this.myProject), this, this.myProject, this.myComposerJson, PLACE).execute();
        }
    }

    @NotNull
    static ComposerCommandExecutor createInstallingExecutor(@NotNull String packageName, final String version, @Nullable String commandLineOptions, final @NotNull ComposerRunningData runningData, @Nullable AddDependencyDialog dialog, @NotNull Project project, @NotNull VirtualFile composerJson, @NotNull String placeForStatistics) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(4);
        }
        if (runningData == null) {
            AddDependencyDialog.$$$reportNull$$$0(5);
        }
        if (project == null) {
            AddDependencyDialog.$$$reportNull$$$0(6);
        }
        if (composerJson == null) {
            AddDependencyDialog.$$$reportNull$$$0(7);
        }
        if (placeForStatistics == null) {
            AddDependencyDialog.$$$reportNull$$$0(8);
        }
        ComposerActionStatistics statistics = ComposerActionStatistics.create("require", placeForStatistics, ComposerOptionsManager.Command.ADD_DEPENDENCY, commandLineOptions);
        AddDependencyCommandExecutor addDependencyCommandExecutor = new AddDependencyCommandExecutor(dialog, project, composerJson, packageName, version, commandLineOptions, runningData, statistics){

            @Override
            protected void reportFeedback(@NotNull ComposerLogMessageBuilder builder, @NotNull List<String> command, boolean success, List<Pair<String, Key>> output, ExecutionException exception, boolean cancelledByUser) {
                if (builder == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (command == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.reportFeedback(builder, command, success, output, exception, cancelledByUser);
                if (this.myDialog != null) {
                    this.myDialog.provideInstallationFeedback(success, ComposerCommandExecutor.createText(output), this.myPackageName, this.myVersion);
                    this.myDialog.getRootPane().setDefaultButton(this.myDialog.getCloseButton());
                    this.myDialog.myChangesListener.run();
                }
            }

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getInstallationCommand(runningData, this.myPackageName, this.myVersion);
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.add.dependency.task.title", new Object[0]);
            }

            @Override
            protected String getActionName() {
                return PhpBundle.message("framework.composer.install.action.name", new Object[0]);
            }

            @Override
            @NotNull
            protected String getCommandDescriptionInPast() {
                if ("installed" == null) {
                    1.$$$reportNull$$$0(3);
                }
                return "installed";
            }

            @Override
            protected void onFinish(boolean success) {
                if (success && this.myDialog != null) {
                    this.myDialog.myForm.addInstalledPackage(this.myPackageName, version);
                    this.myDialog.myForm.refreshPackagesList(true);
                }
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                List<String> beginning = this.myRunningData.getComposerCommandBeginning();
                String composerJsonPath = this.myComposerJson.getPath();
                return AddDependencyDialog.createInstallingGenerator(beginning, composerJsonPath, this.myCommandLineOptions, this.myPackageName, this.myVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommandDescriptionInPast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "reportFeedback";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (addDependencyCommandExecutor == null) {
            AddDependencyDialog.$$$reportNull$$$0(9);
        }
        return addDependencyCommandExecutor;
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createInstallingGenerator(List<String> beginning, String composerJsonPath, String commandLineOptions, String packageName, String version) {
        ThrowableNotNullFunction throwableNotNullFunction = generationProject -> {
            VirtualFile composerJson = LocalFileSystem.getInstance().findFileByPath(composerJsonPath);
            ComposerCommandExecutor.checkFileExists(composerJsonPath, composerJson);
            return AddDependencyDialog.createInstallingExecutor(packageName, version, commandLineOptions, () -> beginning, null, generationProject, composerJson, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            AddDependencyDialog.$$$reportNull$$$0(10);
        }
        return throwableNotNullFunction;
    }

    @NotNull
    static ComposerCommandExecutor createUpdatingExecutor(@NotNull String packageName, @Nullable String commandLineOptions, @NotNull ComposerRunningData runningData, @Nullable AddDependencyDialog dialog, @NotNull Project project, @NotNull VirtualFile composerJson, @NotNull String placeForStatistics) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(11);
        }
        if (runningData == null) {
            AddDependencyDialog.$$$reportNull$$$0(12);
        }
        if (project == null) {
            AddDependencyDialog.$$$reportNull$$$0(13);
        }
        if (composerJson == null) {
            AddDependencyDialog.$$$reportNull$$$0(14);
        }
        if (placeForStatistics == null) {
            AddDependencyDialog.$$$reportNull$$$0(15);
        }
        ComposerActionStatistics statistics = ComposerActionStatistics.create("updatePackage", placeForStatistics, ComposerOptionsManager.Command.ADD_DEPENDENCY, commandLineOptions);
        AddDependencyCommandExecutor addDependencyCommandExecutor = new AddDependencyCommandExecutor(dialog, project, composerJson, packageName, null, commandLineOptions, runningData, statistics){

            @Override
            protected void reportFeedback(@NotNull ComposerLogMessageBuilder builder, @NotNull List<String> command, boolean success, List<Pair<String, Key>> output, ExecutionException exception, boolean cancelledByUser) {
                if (builder == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (command == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.reportFeedback(builder, command, success, output, exception, cancelledByUser);
                if (this.myDialog != null) {
                    this.myDialog.provideUpdateFeedback(success, ComposerCommandExecutor.createText(output), this.myPackageName);
                    this.myDialog.getRootPane().setDefaultButton(this.myDialog.getCloseButton());
                }
            }

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getUpdatePackageCommand(this.myRunningData, this.myPackageName);
                if (list == null) {
                    2.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                List<String> beginning = this.myRunningData.getComposerCommandBeginning();
                String composerJsonPath = this.myComposerJson.getPath();
                return AddDependencyDialog.createUpdatingGenerator(beginning, composerJsonPath, this.myPackageName, this.myCommandLineOptions);
            }

            @Override
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.updating.package.task.title", new Object[0]);
            }

            @Override
            protected String getActionName() {
                return PhpBundle.message("framework.composer.update.action.name", new Object[0]);
            }

            @Override
            @NotNull
            protected String getCommandDescriptionInPast() {
                if ("updated" == null) {
                    2.$$$reportNull$$$0(3);
                }
                return "updated";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommandDescriptionInPast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "reportFeedback";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (addDependencyCommandExecutor == null) {
            AddDependencyDialog.$$$reportNull$$$0(16);
        }
        return addDependencyCommandExecutor;
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createUpdatingGenerator(List<String> beginning, String composerJsonPath, String packageName, String commandLineOptions) {
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile composerJson = LocalFileSystem.getInstance().findFileByPath(composerJsonPath);
            ComposerCommandExecutor.checkFileExists(composerJsonPath, composerJson);
            return AddDependencyDialog.createUpdatingExecutor(packageName, commandLineOptions, () -> beginning, null, generatorProject, composerJson, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            AddDependencyDialog.$$$reportNull$$$0(17);
        }
        return throwableNotNullFunction;
    }

    @NotNull
    static ComposerCommandExecutor createRemovingExecutor(@NotNull String packageName, @Nullable String commandLineOptions, @NotNull ComposerRunningData runningData, @Nullable AddDependencyDialog dialog, @NotNull Project project, @NotNull VirtualFile composerJson, @NotNull String placeForStatistics) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(18);
        }
        if (runningData == null) {
            AddDependencyDialog.$$$reportNull$$$0(19);
        }
        if (project == null) {
            AddDependencyDialog.$$$reportNull$$$0(20);
        }
        if (composerJson == null) {
            AddDependencyDialog.$$$reportNull$$$0(21);
        }
        if (placeForStatistics == null) {
            AddDependencyDialog.$$$reportNull$$$0(22);
        }
        ComposerActionStatistics statistics = ComposerActionStatistics.create("remove", placeForStatistics, ComposerOptionsManager.Command.ADD_DEPENDENCY, commandLineOptions);
        AddDependencyCommandExecutor addDependencyCommandExecutor = new AddDependencyCommandExecutor(dialog, project, composerJson, packageName, null, commandLineOptions, runningData, statistics){

            @Override
            protected void reportFeedback(@NotNull ComposerLogMessageBuilder builder, @NotNull List<String> command, boolean success, List<Pair<String, Key>> output, ExecutionException exception, boolean cancelledByUser) {
                if (builder == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (command == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.reportFeedback(builder, command, success, output, exception, cancelledByUser);
                if (this.myDialog != null) {
                    this.myDialog.provideRemoveFeedback(success, ComposerCommandExecutor.createText(output), this.myPackageName);
                    this.myDialog.getRootPane().setDefaultButton(this.myDialog.getCloseButton());
                }
            }

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getRemovePackageCommand(this.myRunningData, this.myPackageName);
                if (list == null) {
                    3.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.removing.package.task.title", new Object[0]);
            }

            @Override
            protected String getActionName() {
                return PhpBundle.message("framework.composer.remove.action.name", new Object[0]);
            }

            @Override
            @NotNull
            protected String getCommandDescriptionInPast() {
                if ("removed" == null) {
                    3.$$$reportNull$$$0(3);
                }
                return "removed";
            }

            @Override
            protected void onFinish(boolean success) {
                if (success && this.myDialog != null) {
                    this.myDialog.myForm.removeInstalledPackage(this.myPackageName);
                    this.myDialog.myForm.refreshPackagesList(false);
                }
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                List<String> beginning = this.myRunningData.getComposerCommandBeginning();
                String composerJsonPath = this.myComposerJson.getPath();
                return AddDependencyDialog.createRemovingGenerator(beginning, composerJsonPath, this.myPackageName, this.myCommandLineOptions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommandDescriptionInPast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "reportFeedback";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (addDependencyCommandExecutor == null) {
            AddDependencyDialog.$$$reportNull$$$0(23);
        }
        return addDependencyCommandExecutor;
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createRemovingGenerator(List<String> beginning, String composerJsonPath, String packageName, String commandLineOptions) {
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile composerJson = LocalFileSystem.getInstance().findFileByPath(composerJsonPath);
            ComposerCommandExecutor.checkFileExists(composerJsonPath, composerJson);
            return AddDependencyDialog.createRemovingExecutor(packageName, commandLineOptions, () -> beginning, null, generatorProject, composerJson, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            AddDependencyDialog.$$$reportNull$$$0(24);
        }
        return throwableNotNullFunction;
    }

    private JButton getCloseButton() {
        return this.myCloseButton;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action.equals(this.getCancelAction())) {
            this.myCloseButton = button;
        }
        return button;
    }

    private void provideInstallationFeedback(boolean successful, String output, @NotNull String packageName, String version) {
        String message;
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(25);
        }
        if (successful) {
            message = PhpBundle.message("framework.composer.add.dependency.successfully.installed.0.version.1", packageName, version);
        } else {
            String presentableCommand = PhpBundle.message("framework.composer.0.1.version.2", PhpBundle.message("framework.composer.install.action.name", new Object[0]), packageName, version);
            message = PhpBundle.message("framework.composer.failed.to.0", presentableCommand);
        }
        this.provideFeedback(message, output, AddDependencyDialog.getLabelIcon(successful));
    }

    private static Icon getLabelIcon(boolean successful) {
        return successful ? AllIcons.General.BalloonInformation : AllIcons.General.BalloonError;
    }

    private void provideUpdateFeedback(boolean successful, String output, @NotNull String packageName) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(26);
        }
        String message = successful ? (output != null && output.contains("Nothing to install or update") ? PhpBundle.message("framework.composer.add.dependency.no.new.version.found.for.0", packageName) : PhpBundle.message("framework.composer.add.dependency.successfully.updated.0", packageName)) : PhpBundle.message("framework.composer.failed.to.0.1.script.was.cancelled", PhpBundle.message("framework.composer.update.action.name", new Object[0]), packageName);
        this.provideFeedback(message, output, AddDependencyDialog.getLabelIcon(successful));
    }

    private void provideRemoveFeedback(boolean successful, String output, @NotNull String packageName) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(27);
        }
        String message = successful ? PhpBundle.message("framework.composer.add.dependency.successfully.removed.0", packageName) : PhpBundle.message("framework.composer.failed.to.0.1.script.was.cancelled", PhpBundle.message("framework.composer.remove.action.name", new Object[0]), packageName);
        this.provideFeedback(message, output, AddDependencyDialog.getLabelIcon(successful));
    }

    private void provideFeedback(final String message, final String output, Icon icon) {
        this.myInstallationFeedbackLabel.setIcon(icon);
        this.myInstallationFeedbackLabel.setText(message);
        this.myInstallationFeedbackLinkLabel.setText(PhpBundle.message("framework.composer.add.dependency.show.output", new Object[0]));
        if (this.myHyperlinkListener != null) {
            this.myInstallationFeedbackLinkLabel.removeHyperlinkListener(this.myHyperlinkListener);
        }
        this.myHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                AddDependencyDialog.this.myForm.showOutput(output, message, AddDependencyDialog.this.myProject);
            }
        };
        this.myInstallationFeedbackLinkLabel.addHyperlinkListener(this.myHyperlinkListener);
        this.myInstallationFeedbackLabel.setVisible(true);
        this.myInstallationFeedbackLinkLabel.setVisible(true);
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return "composer.add.dependency";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJson";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackages";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog";
                break;
            }
            case 4: 
            case 11: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningData";
                break;
            }
            case 8: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstallingExecutor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstallingGenerator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdatingExecutor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdatingGenerator";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemovingExecutor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemovingGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInstallingExecutor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createUpdatingExecutor";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRemovingExecutor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "provideInstallationFeedback";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "provideUpdateFeedback";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "provideRemoveFeedback";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        AddDependencyForm addDependencyForm = this.myForm;
        JComponent jComponent = addDependencyForm.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCommandLineParametersEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/PhpBundle").getString("framework.composer.add.dependency.settings.cl.label"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myInstallationFeedbackLinkLabel;
        jPanel3.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInstallationFeedbackLabel = jBLabel = new JBLabel();
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel2.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static abstract class AddDependencyCommandExecutor
    extends ComposerPackagedVersionedCommandExecutor {
        @NotNull
        protected final VirtualFile myComposerJson;
        @Nullable
        protected final AddDependencyDialog myDialog;

        protected AddDependencyCommandExecutor(@Nullable AddDependencyDialog dialog, @NotNull Project project, @NotNull VirtualFile composerJson, @NotNull String packageName, String version, @Nullable String commandLineOptions, @NotNull ComposerRunningData runningData, @NotNull ComposerActionStatistics actionStatistics) {
            if (project == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(0);
            }
            if (composerJson == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(1);
            }
            if (packageName == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(2);
            }
            if (runningData == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(3);
            }
            if (actionStatistics == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(4);
            }
            super(project, packageName, version, composerJson.getParent().getPath(), commandLineOptions, runningData, actionStatistics, false);
            this.myDialog = dialog;
            this.myComposerJson = composerJson;
        }

        @Override
        protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
            return new ComposerLogMessageBuilder.SummaryMessage().appendText("Successfully " + this.getCommandDescriptionInPast() + " dependency " + this.myPackageName + " for ").appendLink(this.myComposerJson, this.myProject);
        }

        @NotNull
        protected abstract String getCommandDescriptionInPast();

        @Override
        protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
            return new ComposerLogMessageBuilder.SummaryMessage().appendText("Failed to " + this.getPresentableCommandDescription() + " for ").appendLink(this.myComposerJson, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "composerJson";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runningData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionStatistics";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$AddDependencyCommandExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class RemoveAction
    extends DialogWrapper.DialogWrapperAction {
        private RemoveAction() {
            super((DialogWrapper)AddDependencyDialog.this, "&Remove");
        }

        protected void doAction(ActionEvent e) {
            ComposerPackage aPackage = AddDependencyDialog.this.myForm.getSelectedPackage();
            LOG.assertTrue(aPackage != null);
            String commandLineOptions = AddDependencyDialog.this.myCommandLineParametersEditor.getText();
            LOG.assertTrue(AddDependencyDialog.this.myForm.isSelectedPackageInstalled());
            AddDependencyDialog.createRemovingExecutor(aPackage.getName(), commandLineOptions, ComposerDataService.getInstance(AddDependencyDialog.this.myProject), AddDependencyDialog.this, AddDependencyDialog.this.myProject, AddDependencyDialog.this.myComposerJson, AddDependencyDialog.PLACE).execute();
        }
    }
}

