/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerPhpInterpretersCombo
extends PhpInterpreterComboBox {
    private static final Condition<PhpSdkAdditionalData> LOCAL_INTERPRETERS = data -> !(data instanceof RemoteSdkAdditionalData);

    public ComposerPhpInterpretersCombo(@Nullable Project project) {
        super(project, LOCAL_INTERPRETERS);
        String text = project == null || project.isDefault() ? PhpBundle.message("framework.composer.interpreters.combo.default.interpreter", new Object[0]) : PhpBundle.message("framework.composer.interpreters.combo.default.project.interpreter", new Object[0]);
        this.setNoItemText(text);
    }

    @NotNull
    public static String getPhpPath(@Nullable Project project, String id) {
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if (id == null) {
            PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
            if (interpreter != null && !interpreter.isRemote()) {
                String string = StringUtil.notNullize((String)interpreter.getPathToPhpExecutable());
                if (string == null) {
                    ComposerPhpInterpretersCombo.$$$reportNull$$$0(0);
                }
                return string;
            }
            if ("" == null) {
                ComposerPhpInterpretersCombo.$$$reportNull$$$0(1);
            }
            return "";
        }
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(id);
        if (interpreter != null) {
            String string = StringUtil.notNullize((String)interpreter.getPathToPhpExecutable());
            if (string == null) {
                ComposerPhpInterpretersCombo.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("" == null) {
            ComposerPhpInterpretersCombo.$$$reportNull$$$0(3);
        }
        return "";
    }

    public boolean isModified(String savedName) {
        String name = this.getSelectedItemName();
        if (savedName == null && name == null) {
            return false;
        }
        return !StringUtil.equals((CharSequence)savedName, (CharSequence)name);
    }

    @Nullable
    public String getInterpreterId() {
        String name = this.getSelectedItemName();
        return PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreterId(name);
    }

    public void setInterpreterId(@Nullable String id) {
        String newName = PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreterName(id);
        this.reset(newName);
    }

    public ValidationInfo validateInterpreter() {
        String name = this.getSelectedItemName();
        if (name == null) {
            PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(this.myProject).getInterpreter();
            if (interpreter == null) {
                String message = this.myProject == null || this.myProject.isDefault() ? PhpBundle.message("framework.composer.interpreters.combo.no.default.interpreter", new Object[0]) : PhpBundle.message("framework.composer.interpreters.combo.no.default.interpreter.in.project", new Object[0]);
                return new ValidationInfo(message, (JComponent)((Object)this));
            }
            if (interpreter.isRemote()) {
                return new ValidationInfo(PhpBundle.message("framework.composer.interpreters.combo.remote.default.interpreter", new Object[0]), (JComponent)((Object)this));
            }
            String executable = interpreter.getPathToPhpExecutable();
            if (StringUtil.isEmptyOrSpaces((String)executable)) {
                return new ValidationInfo(PhpBundle.message("framework.composer.interpreters.combo.default.interpreter.no.php.path", new Object[0]), (JComponent)((Object)this));
            }
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/ComposerPhpInterpretersCombo", "getPhpPath"));
    }
}

