/**
 * The MouseEvent interface provides specific contextual information associated with Mouse events.The detail attribute inherited from UIEvent indicates the number of times a mouse button has been pressed and released over the same screen location during a user action. The attribute value is 1 when the user begins this action and increments by 1 for each full sequence of pressing and releasing. If the user moves the mouse between the mousedown and mouseup the value will be set to 0, indicating that no click is occurring.In the case of nested elements mouse events are always targeted at the most deeply nested element. Ancestors of the targeted element may use bubbling to obtain notification of mouse events which occur within its descendent elements.
 */
var MouseEvent = {
}
/**
 * The vertical coordinate at which the event occurred relative to the DOM implementation's client area.
 * @syntax mouseEvent.clientY
 * @returns {Number} 
 */
MouseEvent.prototype.clientY = new Number();

/**
 * Used to indicate whether the 'meta' key was depressed during the firing of the event. On some platforms this key may map to an alternative key name.
 * @syntax mouseEvent.metaKey
 * @returns {boolean} 
 */
MouseEvent.prototype.metaKey = new boolean();

/**
 * The horizontal coordinate at which the event occurred relative to the DOM implementation's client area.
 * @syntax mouseEvent.clientX
 * @returns {Number} 
 */
MouseEvent.prototype.clientX = new Number();

/**
 * During mouse events caused by the depression or release of a mouse button, button is used to indicate which mouse button changed state. The values for button range from zero to indicate the left button of the mouse, one to indicate the middle button if present, and two to indicate the right button. For mice configured for left handed use in which the button actions are reversed the values are instead read from right to left.
 * @syntax mouseEvent.button
 * @returns {Number} 
 */
MouseEvent.prototype.button = new Number();

/**
 * Used to indicate whether the 'alt' key was depressed during the firing of the event. On some platforms this key may map to an alternative key name.
 * @syntax mouseEvent.altKey
 * @returns {boolean} 
 */
MouseEvent.prototype.altKey = new boolean();

/**
 * Used to indicate whether the 'shift' key was depressed during the firing of the event.
 * @syntax mouseEvent.shiftKey
 * @returns {boolean} 
 */
MouseEvent.prototype.shiftKey = new boolean();

/**
 * The initMouseEvent method is used to initialize the value of a MouseEvent created through the DocumentEvent interface. This method may only be called before the MouseEvent has been dispatched via the dispatchEvent method, though it may be called multiple times during that phase if necessary. If called multiple times, the final invocation takes precedence.
 * @syntax mouseEvent.initMouseEvent(typeArg, canBubbleArg, cancelableArg, viewArg, detailArg, screenXArg, screenYArg, clientXArg, clientYArg, ctrlKeyArg, altKeyArg, shiftKeyArg, metaKeyArg, buttonArg, relatedTargetArg)
 * @param {String} typeArg Specifies the event type.
 * @param {boolean} canBubbleArg Specifies whether or not the event can bubble.
 * @param {boolean} cancelableArg Specifies whether or not the event's default action can be prevented.
 * @param {views::AbstractView} viewArg Specifies the Event's AbstractView.
 * @param {Number} detailArg Specifies the Event's mouse click count.
 * @param {Number} screenXArg Specifies the Event's screen x coordinate
 * @param {Number} screenYArg Specifies the Event's screen y coordinate
 * @param {Number} clientXArg Specifies the Event's client x coordinate
 * @param {Number} clientYArg Specifies the Event's client y coordinate
 * @param {boolean} ctrlKeyArg Specifies whether or not control key was depressed during the Event.
 * @param {boolean} altKeyArg Specifies whether or not alt key was depressed during the Event.
 * @param {boolean} shiftKeyArg Specifies whether or not shift key was depressed during the Event.
 * @param {boolean} metaKeyArg Specifies whether or not meta key was depressed during the Event.
 * @param {Number} buttonArg Specifies the Event's mouse button.
 * @param {EventTarget} relatedTargetArg Specifies the Event's related EventTarget.
 * @returns {undefined} 
 */
MouseEvent.prototype.initMouseEvent = function(typeArg,  canBubbleArg,  cancelableArg,  viewArg,  detailArg,  screenXArg,  screenYArg,  clientXArg,  clientYArg,  ctrlKeyArg,  altKeyArg,  shiftKeyArg,  metaKeyArg,  buttonArg,  relatedTargetArg) {};

/**
 * Used to identify a secondary EventTarget related to a UI event. Currently this attribute is used with the mouseover event to indicate the EventTarget which the pointing device exited and with the mouseout event to indicate the EventTarget which the pointing device entered.
 * @syntax mouseEvent.relatedTarget
 * @returns {EventTarget} 
 */
MouseEvent.prototype.relatedTarget = new EventTarget();

/**
 * Used to indicate whether the 'ctrl' key was depressed during the firing of the event.
 * @syntax mouseEvent.ctrlKey
 * @returns {boolean} 
 */
MouseEvent.prototype.ctrlKey = new boolean();

/**
 * The vertical coordinate at which the event occurred relative to the origin of the screen coordinate system.
 * @syntax mouseEvent.screenY
 * @returns {Number} 
 */
MouseEvent.prototype.screenY = new Number();

/**
 * The horizontal coordinate at which the event occurred relative to the origin of the screen coordinate system.
 * @syntax mouseEvent.screenX
 * @returns {Number} 
 */
MouseEvent.prototype.screenX = new Number();

/**
 * Represents the MouseEvent prototype object.
 * @syntax MouseEvent.prototype
 * @static
 */
MouseEvent.prototype;

