package org.clank.support.aliases;

import org.clank.support.Converted;
import org.clank.support.*;
import org.clank.java.std;
import static org.clank.support.NativeType.*;
import static org.clank.support.NativeMemory.*;
import static org.clank.support.NativePointer.*;

/**
 * Array based implementation of pointer to ${TYPE}
 */
//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.clank.java/src/org/clank/support/aliases/templates/pointerarrayimpl.tpl")
//</editor-fold>
public final class ${FILE_NAME}${CLASS_SUFFIX} extends AbstractArrayPointerType<${POINTER_NAME}> implements ${POINTER_NAME} {
    
    protected ${TYPE}[] array;

    protected ${FILE_NAME}(${FILE_NAME}${CLASS_SUFFIX} other, boolean makeConstPtr, boolean makeConstContent) {
      super(other, makeConstPtr, makeConstContent);
      this.array = other.array;
      trackInstance(makeConstPtr, makeConstContent);
    }
  
    public ${FILE_NAME}() {
        this(null, 0, false, false);
    }

    public ${FILE_NAME}(${TYPE}[] arr) {
        this(arr, 0, false, false);
    }

    public ${FILE_NAME}(${TYPE}[] arr, int idx) {
        this(arr, idx, false, false);
    }

    public ${FILE_NAME}(${TYPE}[] arr, boolean makeConstPtr) {
        this(arr, 0, makeConstPtr, false);
    }

    public ${FILE_NAME}(${TYPE}[] arr, int idx, boolean makeConstPtr) {
        this(arr, idx, makeConstPtr, false);
    }

    public ${FILE_NAME}(${TYPE}[] arr, int idx, boolean makeConstPtr, boolean makeConstContent) {
        super(makeConstPtr, makeConstContent);
        this.array = arr;
        assert idx >= 0 : "can not be negative " + idx;
        this.index = idx;
        trackInstance(makeConstPtr, makeConstContent);
    }

    ///////////////////////////////////////////////////////////////////////////
    // common operations

    @Override
    public boolean $isNull() {
        return array == null;
    }

    @Override
    public ${TYPE} $star() {
        return array[index];
    }

    @Override
    public ${TYPE} $set(${TYPE} value) {
        return $set(0, value);
    }

    @Override
    public ${TYPE} $at(int index) {
        return array[(this.index + index)];
    }

    @Override
    public int $sub(${POINTER_NAME} other) {
      assert other instanceof ${FILE_NAME} : "unexpected object " + other;
      return (index - ((${FILE_NAME})other).index);
    }
    
    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} $add(int amount) {
      ${FILE_NAME}${CLASS_SUFFIX} cloned = new ${FILE_NAME}${CLASS_SUFFIX}(this, false, _isConstContent());
      cloned.index += amount;
      return cloned;
    }

    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} $sub(int amount) {
      ${FILE_NAME}${CLASS_SUFFIX} cloned = new ${FILE_NAME}${CLASS_SUFFIX}(this, false, _isConstContent());
      cloned.index -= amount;
      return cloned;
    }
  
    @Override
    public ${TYPE} $set(int index, ${TYPE} value) {
      assert !_isConstContent() : "Cannot modify content because it is constant!";
      ${SET_IMPL}
    }   
    ${BUILTIN_TYPE_MODIFY_VALUE_SECTION_START}
    @Override
    public ${TYPE} $set$andassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] &= value;
    }

    @Override
    public ${TYPE} $set$xorassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] ^= value;
    }

    @Override
    public ${TYPE} $set$orassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] |= value;
    }

    ${BUILTIN_TYPE_MODIFY_VALUE_SECTION_END}${ADDITIONAL_MODIFY_VALUE_SECTION_START}

    @Override
    public ${TYPE} $set$addassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] += value;
    }

    @Override
    public ${TYPE} $set$minusassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] -= value;
    }

    @Override
    public ${TYPE} $set$starassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] *= value;
    }

    @Override
    public ${TYPE} $set$slashassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] /= value;
    }

    @Override
    public ${TYPE} $set$modassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] %= value;
    }

    @Override
    public ${TYPE} $set$lshiftassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] <<= value;
    }

    @Override
    public ${TYPE} $set$rshiftassign(int index, ${TYPE} value) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)] >>= value;
    }

    @Override
    public ${TYPE} $set$postInc(int index) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)]++;
    }
    
    @Override
    public ${TYPE} $set$postDec(int index) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return array[(this.index + index)]--;
    }

    @Override
    public ${TYPE} $set$preInc(int index) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return ++array[(this.index + index)];
    }

    @Override
    public ${TYPE} $set$preDec(int index) {
        assert !_isConstContent() : "Cannot modify content because it is constant!";
        return --array[(this.index + index)];
    }

    ${ADDITIONAL_MODIFY_VALUE_SECTION_END}

    @Override
    public ${POINTER_NAME} $assign(${POINTER_NAME} value) {
        assert !_isConstPtr() : "Cannot modify const object!";
        if (value instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} val = (${FILE_NAME}${CLASS_SUFFIX})value;
            array = val.array;
            index = val.index;
            return this;
        } ${ADDITIONAL_ASSIGNMENTS}
        throw new IllegalArgumentException(
                "Different pointer types: expected '" + getClass().getName() + "'" 
                + ", but found '" + (value != null ? value.getClass() : "null") + "'"
        );            
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
      return other instanceof ${FILE_NAME} && ((${FILE_NAME}) other).array == this.array;
    }
    
    @Override
    public boolean $less(Object obj) {
        if (obj instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) obj;
            return other.array == this.array && ((index - other.index) < 0);
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) obj;
            return other.array == this.array && ((index - other.index) <= 0);
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) obj;
            return other.array == this.array && ((index - other.index) > 0);
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + getClass() + " and " + obj.getClass());          
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) obj;
            return other.array == this.array && ((index - other.index) >= 0);
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + getClass() + " and " + obj.getClass());          
    }
    
    @Override
    public boolean $eq(Object p) {
        if (p instanceof ${FILE_NAME}) {
            ${FILE_NAME}${CLASS_SUFFIX} other = (${FILE_NAME}${CLASS_SUFFIX}) p;
            return other.array == this.array && index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !$eq(p);
    }        

    @Override
    public ${REFERENCE_NAME} star$ref() {
      return new ${REFERENCE_NAME}() {

            // use outer instance if only $set/$deref is needed
            ${FILE_NAME}${CLASS_SUFFIX} localPtr = ${FILE_NAME}.this;

            @Override
            public ${TYPE} $deref() {
                return localPtr.$star();
            }

            @Override
            public ${TYPE} $set(${TYPE} value) {
                return localPtr.$set(value);
            }

            @Override
            public ${POINTER_NAME} deref$ptr() {
                // we have to make a copy,
                // otherwise ++/-- will change outer instance
                if (localPtr == ${FILE_NAME}.this) {
                  localPtr = localPtr.clone();
                }
                return localPtr;
            }
        };
    }

    @Override
    public int $hashcode() {
        return (System.identityHashCode(this.array)) ^ index;
    }

    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} clone() {
      return new ${FILE_NAME}(this, false, _isConstContent());
    }

    @Override
    public ${FILE_NAME}${CLASS_SUFFIX} const_clone() {
      return super._isConstPtr() ? this : new ${FILE_NAME}(this, true, _isConstContent());
    }

    @Override
    public String toString() {
      if (array == null || array.length == 0) {
        return "<EMPTY>";
      }
      StringBuilder sb = new StringBuilder("\n" + ${FILE_NAME}.class.getSimpleName() + "{range=[" + this.index + "-" + array.length + "]\n");
      String fmt = "%" + (int) Math.ceil(Math.log10(array.length + 1)) + "d";
      for (int i = (int) this.index; i < array.length; i++) {
        ${TYPE} b = array[i];
        ${SB_APPEND_ELEMENT_I};
        if ((i - this.index) > NativeTrace.TO_STRING_LIMIT) {
          sb.append("...."); break;
        }
      }
      sb.append("}").append(${FILE_NAME}.class.getSimpleName()).append("\n");
      return sb.toString();
    }  

    ////////////////////////////////////////////////////////////////////////////
    // statistics
    private static long nonConstInstances = 0;
    private static long constPtrInstances = 0;
    private static long constContentInstances = 0;
    private static long fullyConstInstances = 0;

    public static void trackInstance(boolean constPtr, boolean constContent) {
        if (NativeTrace.STATISTICS) {
            if (constPtr && constContent) {
                fullyConstInstances++;
            } else if (constPtr) {
                constPtrInstances++;
            } else if (constContent) {
                constContentInstances++;
            } else {
                nonConstInstances++;
            }
        }
    }

    public static void clearStatistics() {
        fullyConstInstances = 0;
        constPtrInstances = 0;
        constContentInstances = 0;
        nonConstInstances = 0;
    }

    public static long printStatistics(java.io.PrintWriter out) {
        final long totalInstances = nonConstInstances + fullyConstInstances + constPtrInstances + constContentInstances;
        out.printf("%30s created all:\t%s%n", ${FILE_NAME}.class.getSimpleName(), NativeTrace.formatNumber(totalInstances));
        out.printf("%32s non const:\t%s%n", ${FILE_NAME}.class.getSimpleName(), NativeTrace.formatNumber(nonConstInstances));
        out.printf("%32s const ptr:\t%s%n", ${FILE_NAME}.class.getSimpleName(), NativeTrace.formatNumber(constPtrInstances));
        out.printf("%28s const content:\t%s%n", ${FILE_NAME}.class.getSimpleName(), NativeTrace.formatNumber(constContentInstances));
        out.printf("%20s const ptr and content:\t%s%n", ${FILE_NAME}.class.getSimpleName(), NativeTrace.formatNumber(fullyConstInstances));
        return totalInstances;
    }
    ///////////////////////////////////////////////////////////////////////////
    // performance access operations
    public final ${TYPE}[] $array() {
      return this.array;
    }
}