/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ant.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNodeAction;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.java.testrunner.OutputUtils;
import org.netbeans.modules.junit.ant.ui.Bundle;
import org.netbeans.modules.junit.api.JUnitTestcase;
import org.netbeans.modules.junit.ui.api.JUnitTestMethodNode;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class AntJUnitTestMethodNode
extends JUnitTestMethodNode {
    public AntJUnitTestMethodNode(Testcase testcase, Project project, Lookup lookup, String projectType, String testingFramework) {
        super(testcase, project, lookup, projectType, testingFramework);
    }

    public AntJUnitTestMethodNode(Testcase testcase, Project project, String projectType, String testingFramework) {
        super(testcase, project, projectType, testingFramework);
    }

    public Action[] getActions(boolean context) {
        FileObject testFO;
        ArrayList<Action> actions = new ArrayList<Action>();
        Action preferred = this.getPreferredAction();
        if (preferred != null) {
            actions.add(preferred);
        }
        if ((testFO = ((JUnitTestcase)this.testcase).getClassFileObject(true)) == null) {
            Logger.getLogger(AntJUnitTestMethodNode.class.getName()).log(Level.INFO, "Test running process was probably abnormally interrupted. Could not locate FileObject for {0}", this.testcase.toString());
            for (Action prefAction : actions) {
                prefAction.setEnabled(false);
            }
        } else {
            ActionProvider actionProvider;
            boolean parameterized = false;
            try {
                String text = testFO.asText();
                if (text != null && ((text = text.replaceAll("\n", "").replaceAll(" ", "")).contains("@RunWith") || text.contains("@org.junit.runner.RunWith")) && text.contains("Parameterized.class)")) {
                    parameterized = true;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!parameterized && (actionProvider = OutputUtils.getActionProvider((FileObject)testFO)) != null) {
                List<String> supportedActions = Arrays.asList(actionProvider.getSupportedActions());
                SingleMethod methodSpec = new SingleMethod(testFO, this.testcase.getName());
                Lookup nodeContext = Lookups.singleton((Object)methodSpec);
                if (supportedActions.contains("run.single.method") && actionProvider.isActionEnabled("run.single.method", nodeContext)) {
                    actions.add((Action)new TestMethodNodeAction(actionProvider, nodeContext, "run.single.method", Bundle.LBL_RerunTest()));
                }
                if (supportedActions.contains("debug.single.method") && actionProvider.isActionEnabled("debug.single.method", nodeContext)) {
                    actions.add((Action)new TestMethodNodeAction(actionProvider, nodeContext, "debug.single.method", Bundle.LBL_DebugTest()));
                }
            }
        }
        actions.addAll(Arrays.asList(super.getActions(context)));
        return actions.toArray(new Action[actions.size()]);
    }
}

