/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.service.spi;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.mapping.HibernateMappingDataObject;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.service.TableColumn;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.CustomClassLoader;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class HibernateEnvironmentImpl
implements HibernateEnvironment {
    private Project project;
    private Logger logger = Logger.getLogger(HibernateEnvironmentImpl.class.getName());
    private WeakReference<CustomClassLoader> loaderRef;

    public HibernateEnvironmentImpl(Project project) {
        this.project = project;
    }

    @Override
    public boolean canLoadDBDriver(HibernateConfiguration config) {
        String dbDriver = HibernateUtil.getDbConnectionDetails(config, "hibernate.connection.driver_class");
        if (dbDriver == null || "".equals(dbDriver)) {
            dbDriver = HibernateUtil.getDbConnectionDetails(config, "connection.driver_class");
        }
        if (dbDriver == null || "".equals(dbDriver)) {
            this.logger.info("dbDriver class could not be found from the config.");
            return false;
        }
        JDBCDriver jdbcDriver = null;
        DatabaseConnection dbConnection = null;
        try {
            dbConnection = HibernateUtil.getDBConnection(config);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (dbConnection != null) {
            jdbcDriver = dbConnection.getJDBCDriver();
        }
        try {
            List<URL> urls = this.getProjectClassPath();
            if (jdbcDriver != null) {
                urls.addAll(Arrays.asList(jdbcDriver.getURLs()));
            }
            ClassLoader ccl = this.getProjectClassLoader(urls.toArray(new URL[0]));
            ccl.loadClass(dbDriver);
            this.logger.info("dbDriver loaded.");
            return true;
        }
        catch (Exception exception) {
            this.logger.info("Could not load dbDriver class. CNFE");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDirectlyConnectToDB(HibernateConfiguration config) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader ccl = null;
        try {
            List<URL> urls = this.getProjectClassPath();
            DatabaseConnection dbconn = HibernateUtil.getDBConnection(config);
            if (dbconn != null) {
                dbconn.getJDBCConnection();
                JDBCDriver driver = dbconn.getJDBCDriver();
                if (driver != null) {
                    urls.addAll(Arrays.asList(driver.getURLs()));
                }
            }
            ccl = this.getProjectClassLoader(urls.toArray(new URL[0]));
            Thread.currentThread().setContextClassLoader(ccl);
            HibernateUtil.getDirectDBConnection(config);
            this.logger.info("Direct Database connection established.");
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Cannot establish direct database connection", e);
        }
        finally {
            if (ccl != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        return false;
    }

    @Override
    public FileObject getSourceLocation() {
        SourceGroup[] sourceGroups = HibernateUtil.getSourceGroups(this.project);
        if (sourceGroups != null && sourceGroups.length != 0) {
            return sourceGroups[0].getRootFolder();
        }
        return null;
    }

    @Override
    public List<String> getAllDatabaseTablesForProject() {
        return this.getAllDatabaseTables(HibernateUtil.getAllHibernateConfigurations(this.project).toArray(new HibernateConfiguration[0]));
    }

    @Override
    public List<String> getDatabaseTables(FileObject mappingFile) {
        ArrayList<String> databaseTables = new ArrayList<String>();
        try {
            List<HibernateConfiguration> configurations = this.getHibernateConfigurationForMappingFile(mappingFile);
            if (configurations.size() == 0) {
                return databaseTables;
            }
            databaseTables.addAll(HibernateUtil.getAllDatabaseTables(configurations.toArray(new HibernateConfiguration[0])));
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (HibernateException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return databaseTables;
    }

    @Override
    public List<HibernateConfiguration> getAllHibernateConfigurationsFromProject() {
        return HibernateUtil.getAllHibernateConfigurations(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateConfigFileObjects() {
        return HibernateUtil.getAllHibernateConfigFileObjects(this.project);
    }

    @Override
    public List<FileObject> getDefaultHibernateConfigFileObjects() {
        return HibernateUtil.getDefaultHibernateConfigFileObjects(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateMappingFileObjects() {
        return HibernateUtil.getAllHibernateMappingFileObjects(this.project);
    }

    @Override
    public List<String> getAllHibernateMappings() {
        return HibernateUtil.getAllHibernateMappingsRelativeToSourcePath(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateReverseEnggFileObjects() {
        return HibernateUtil.getAllHibernateReverseEnggFileObjects(this.project);
    }

    @Override
    public List<String> getAllDatabaseTables(HibernateConfiguration ... configurations) {
        try {
            return HibernateUtil.getAllDatabaseTables(configurations);
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (HibernateException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    @Override
    public List<String> getAllDatabaseTablesOnEventThread(FileObject configurationFO) throws DataObjectNotFoundException, DatabaseException, SQLException {
        return HibernateUtil.getAllDatabaseTablesOnEventThread(configurationFO);
    }

    @Override
    public List<TableColumn> getColumnsForTable(String tableName, FileObject mappingFileObject) {
        ArrayList<TableColumn> columnNames = new ArrayList<TableColumn>();
        List<HibernateConfiguration> hibernateConfigurations = this.getHibernateConfigurationForMappingFile(mappingFileObject);
        if (hibernateConfigurations.size() == 0) {
            return columnNames;
        }
        for (HibernateConfiguration hibernateConfiguration : hibernateConfigurations) {
            columnNames.addAll(HibernateUtil.getColumnsForTable(tableName, hibernateConfiguration));
        }
        return columnNames;
    }

    @Override
    public boolean addHibernateLibraryToProject(FileObject fileInProject) {
        boolean addLibraryResult = false;
        try {
            LibraryManager libraryManager = LibraryManager.getDefault();
            Library hibernateLibrary = libraryManager.getLibrary("hibernate4-support");
            Library ejb3PersistenceLibrary = libraryManager.getLibrary("jpa2-persistence");
            Library[] librariesToBeRegistered = null;
            this.project.getProjectDirectory().getFileSystem().refresh(true);
            ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
            if (cp == null) {
                this.logger.info("Cannot register libraries because cannot get the classpath for created file : " + fileInProject);
                return false;
            }
            librariesToBeRegistered = !this.containsClass(cp, "javax.persistence.EntityManager") ? new Library[]{hibernateLibrary, ejb3PersistenceLibrary} : new Library[]{hibernateLibrary};
            addLibraryResult = ProjectClassPathModifier.addLibraries((Library[])librariesToBeRegistered, (FileObject)fileInProject, (String)"classpath/compile");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            addLibraryResult = false;
        }
        catch (UnsupportedOperationException ex) {
            this.logger.info("Library registration not possible : " + this.project);
        }
        return addLibraryResult;
    }

    @Override
    public List<String> getAllHibernateMappingsFromConfiguration(HibernateConfiguration hibernateConfiguration) {
        ArrayList<String> mappingsFromConfiguration = new ArrayList<String>();
        SessionFactory fact = hibernateConfiguration.getSessionFactory();
        ArrayList<String> mappingsFromJavaPackage = new ArrayList<String>();
        int count = 0;
        for (boolean val : fact.getMapping()) {
            String propName = fact.getAttributeValue("Mapping", count, "resource");
            if (propName != null) {
                mappingsFromConfiguration.add(propName);
            }
            if ((propName = fact.getAttributeValue("Mapping", count, "file")) != null) {
                mappingsFromConfiguration.add(propName);
            }
            if ((propName = fact.getAttributeValue("Mapping", count, "package")) != null) {
                mappingsFromJavaPackage.add(propName);
            }
            ++count;
        }
        if (mappingsFromJavaPackage.size() != 0) {
            List<String> allMappingFilesRelativeToSourceRoot = HibernateUtil.getAllHibernateMappingsRelativeToSourcePath(this.project);
            for (String mappingRelativeToSourceRoot : allMappingFilesRelativeToSourceRoot) {
                for (String mappingFromPackage : mappingsFromJavaPackage) {
                    if (!mappingRelativeToSourceRoot.startsWith(mappingFromPackage = mappingFromPackage.replace(".", "/"))) continue;
                    mappingsFromConfiguration.add(mappingRelativeToSourceRoot);
                }
            }
        }
        return mappingsFromConfiguration;
    }

    private List<HibernateConfiguration> getHibernateConfigurationForMappingFile(FileObject mappingFileObject) {
        ArrayList<HibernateConfiguration> hibernateConfigurations = new ArrayList<HibernateConfiguration>();
        for (HibernateConfiguration config : this.getAllHibernateConfigurationsFromProject()) {
            for (String mappingFile : this.getAllHibernateMappingsFromConfiguration(config)) {
                if (mappingFile.trim().equals("") || !mappingFileObject.getPath().contains(mappingFile)) continue;
                hibernateConfigurations.add(config);
            }
        }
        return hibernateConfigurations;
    }

    @Override
    public List<URL> getProjectClassPath(FileObject projectFile) {
        return HibernateUtil.getProjectClassPathEntries(projectFile);
    }

    @Override
    public List<URL> getProjectClassPath() {
        return HibernateUtil.getProjectClassPath(this.project);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public List<String> getAnnotatedPOJOClassNames(FileObject configurationFO) {
        ArrayList<String> annototedPOJOClassNameList = new ArrayList<String>();
        try {
            HibernateCfgDataObject configDO = (HibernateCfgDataObject)DataObject.find((FileObject)configurationFO);
            HibernateConfiguration configuration = configDO.getHibernateConfiguration();
            SessionFactory fact = configuration.getSessionFactory();
            int count = 0;
            for (boolean val : fact.getMapping()) {
                String propName;
                if ((propName = fact.getAttributeValue("Mapping", count++, "class")) == null) continue;
                annototedPOJOClassNameList.add(propName);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            this.logger.log(Level.INFO, "DataObject not found during Annototated POJO procesing.", dataObjectNotFoundException);
        }
        return annototedPOJOClassNameList;
    }

    @Override
    public Map<FileObject, List<String>> getAllPOJONamesFromConfiguration(FileObject configFileObject) {
        HashMap<FileObject, List<String>> mappingPOJOMap = new HashMap<FileObject, List<String>>();
        try {
            HibernateCfgDataObject hibernateCfgDO = (HibernateCfgDataObject)DataObject.find((FileObject)configFileObject);
            for (String mappingFileName : this.getAllHibernateMappingsFromConfiguration(hibernateCfgDO.getHibernateConfiguration())) {
                for (FileObject mappingFO : this.getAllHibernateMappingFileObjects()) {
                    if (!mappingFileName.contains(mappingFO.getName())) continue;
                    List<String> l = this.getPOJONameFromMapping(mappingFO);
                    mappingPOJOMap.put(mappingFO, l);
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return mappingPOJOMap;
    }

    private List<String> getPOJONameFromMapping(FileObject mappingFO) {
        ArrayList<String> pojoNamesList = new ArrayList<String>();
        try {
            HibernateMappingDataObject hibernateMappingDO = (HibernateMappingDataObject)DataObject.find((FileObject)mappingFO);
            for (MyClass myClass : hibernateMappingDO.getHibernateMapping().getMyClass()) {
                String propName = myClass.getAttributeValue("name");
                pojoNamesList.add(propName);
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return pojoNamesList;
    }

    private boolean containsClass(ClassPath cp, String className) {
        String classRelativePath = className.replace('.', '/') + ".class";
        return cp.findResource(classRelativePath) != null;
    }

    @Override
    public boolean registerDBDriver(String driver, FileObject primaryFile) {
        boolean registeredDBDriver = false;
        JDBCDriver[] jdbcDrivers = JDBCDriverManager.getDefault().getDrivers(driver);
        ArrayList<URL> driverURLs = new ArrayList<URL>();
        for (JDBCDriver jdbcDriver : jdbcDrivers) {
            for (URL url : jdbcDriver.getURLs()) {
                File file = null;
                if (url.getProtocol().equals("nbinst")) {
                    try {
                        file = InstalledFileLocator.getDefault().locate(url.getFile().substring(1), null, false);
                        this.logger.info("Bundled DB Driver Jar : " + file);
                        if (file == null) continue;
                        url = file.toURI().toURL();
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    this.logger.info("User provided DB Driver Jar : " + url);
                }
                if (FileUtil.isArchiveFile((URL)url)) {
                    driverURLs.add(FileUtil.getArchiveRoot((URL)url));
                    continue;
                }
                driverURLs.add(url);
            }
        }
        try {
            registeredDBDriver = ProjectClassPathModifier.addRoots((URL[])driverURLs.toArray(new URL[0]), (FileObject)primaryFile, (String)"classpath/compile");
        }
        catch (UnsupportedOperationException e) {
            this.logger.info("DB Driver registration not possible : " + this.project);
            registeredDBDriver = false;
        }
        catch (Exception e) {
            registeredDBDriver = false;
            this.logger.log(Level.INFO, "Problem in registering db driver.", e);
        }
        return registeredDBDriver;
    }

    @Override
    public ClassLoader getProjectClassLoader(URL[] classpaths) {
        Object[] oldUrls;
        CustomClassLoader cL;
        CustomClassLoader customClassLoader = new CustomClassLoader(classpaths, this.getClass().getClassLoader());
        if (this.loaderRef != null && (cL = (CustomClassLoader)this.loaderRef.get()) != null && Arrays.equals(oldUrls = cL.getURLs(), classpaths = customClassLoader.getURLs())) {
            return cL;
        }
        this.loaderRef = new WeakReference<CustomClassLoader>(customClassLoader);
        return customClassLoader;
    }
}

