/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCToolTask;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class JCPackagerTask
extends JCToolTask {
    private boolean overwrite;

    public JCPackagerTask() {
        this(true);
    }

    public JCPackagerTask(boolean overwrite) {
        super(System.getProperty("packager.task") == null ? "com.sun.javacard.packager.Main" : System.getProperty("packager.task"));
        this.overwrite = overwrite;
    }

    public void execute() throws BuildException {
        String exportPath;
        boolean signbundle;
        this.createArg().setValue("create");
        assert (this.getProject() != null);
        assert (this.getProject().getBaseDir() != null);
        Project p = this.getProject();
        File basedir = p.getBaseDir();
        if (basedir == null) {
            throw new BuildException("Basedir not set");
        }
        File distBundle = this.getFileProp("dist.bundle", true);
        this.createArg().setValue("--out");
        this.createArg().setFile(distBundle);
        if (this.overwrite) {
            distBundle.delete();
            this.createArg().setValue("--force");
        }
        if (this.isClassicLibrary()) {
            this.createArg().setValue("--packageaid");
            this.createArg().setValue(this.getProject().getProperty("package.aid"));
        }
        if (signbundle = this.getBool("sign.bundle")) {
            this.createArg().setValue("--sign");
            this.createArg().setValue("-K");
            this.createArg().setFile(new File(this.getProp("keystore.resolved")));
            this.createArg().setValue("-S");
            this.createArg().setValue(this.getProp("sign.storepass"));
            this.createArg().setValue("-P");
            this.createArg().setValue(this.getProp("sign.passkey"));
            this.createArg().setValue("-A");
            this.createArg().setValue(this.getProp("sign.alias"));
        }
        this.createArg().setValue("--type");
        this.createArg().setValue(this.getType());
        if ((this.isClassicLibrary() || this.isClassicApplication()) && (exportPath = this.getExportPath()).length() > 0) {
            this.createArg().setValue("--exportpath");
            this.createArg().setValue(exportPath);
        }
        this.setAdditionalArguments();
        File bdirFile = this.getFileProp("build.dir");
        if (!bdirFile.exists()) {
            throw new BuildException(bdirFile.getAbsolutePath() + " does not exist");
        }
        if (!bdirFile.isDirectory()) {
            throw new BuildException(bdirFile.getAbsolutePath() + " is not a folder");
        }
        this.createArg().setFile(bdirFile);
        this.log("Execute\n" + this.getCommandLine(), 3);
        super.execute();
        if (!distBundle.exists()) {
            throw new BuildException("Creation of " + distBundle + " was not successful. See Packager output");
        }
    }

    protected void setAdditionalArguments() throws BuildException {
    }
}

