/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.antlr;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenImpl;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;

public class TokenBuffer {
    private int nMarkers = 0;
    private int p = 0;
    public static final int INITIAL_BUFFER_SIZE = 2048;
    private final List<Token> tokens;
    private final int size;
    private short[] data;

    public TokenBuffer(TokenStream input) {
        this(input, 2048);
    }

    public TokenBuffer(TokenStream input, int initialCapacity) {
        this.tokens = new ArrayList<Token>(initialCapacity);
        this.data = new short[initialCapacity];
        int pos = 0;
        try {
            int type;
            Token t = input.nextToken();
            while (t != null && (type = t.getType()) != 1) {
                this.tokens.add(t);
                if (pos == this.data.length) {
                    this.resizeData();
                }
                assert (type < Short.MAX_VALUE);
                this.data[pos++] = (short)type;
                t = input.nextToken();
            }
        }
        catch (TokenStreamException tse) {
            System.err.println("tmp error: can't load tokens: " + tse);
        }
        this.size = pos;
    }

    private void resizeData() {
        short[] newdata = new short[this.data.length * 2];
        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
        this.data = newdata;
    }

    public final void consume() {
        ++this.p;
    }

    public final int LA(int i) {
        int dataPos = this.p + i - 1;
        if (dataPos >= this.size) {
            return 1;
        }
        return this.data[dataPos];
    }

    public final Token LT(int i) {
        int dataPos = this.p + i - 1;
        if (dataPos < 0 || dataPos >= this.size) {
            return TokenImpl.EOF_TOKEN;
        }
        return this.tokens.get(dataPos);
    }

    public final int size() {
        return this.size;
    }

    public final int mark() {
        ++this.nMarkers;
        return this.p;
    }

    public final int index() {
        return this.p;
    }

    public final void seek(int position) {
        this.p = position;
    }

    public final void rewind(int marker) {
        this.seek(marker);
        --this.nMarkers;
    }
}

