/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.antlr;

import org.netbeans.modules.cnd.antlr.CharScanner;

public final class ANTLRHashString {
    private String s;
    private char[] buf;
    private int len;
    private CharScanner lexer;
    private boolean caseSensitiveLiterals;
    private int hashCode = -1;
    private static final int prime = 151;

    public ANTLRHashString(char[] buf, int length, CharScanner lexer) {
        this.lexer = lexer;
        this.caseSensitiveLiterals = lexer.getCaseSensitiveLiterals();
        this.setBuffer(buf, length);
    }

    public ANTLRHashString(CharScanner lexer) {
        this.lexer = lexer;
        this.caseSensitiveLiterals = lexer.getCaseSensitiveLiterals();
    }

    public ANTLRHashString(String s, CharScanner lexer) {
        this.lexer = lexer;
        this.caseSensitiveLiterals = lexer.getCaseSensitiveLiterals();
        this.setString(s);
    }

    public ANTLRHashString(String s, boolean caseSensitiveLiterals) {
        this.lexer = null;
        this.caseSensitiveLiterals = caseSensitiveLiterals;
        this.setString(s);
    }

    private final char charAt(int index) {
        return this.s != null ? this.s.charAt(index) : this.buf[index];
    }

    public boolean equals(Object o) {
        if (!(o instanceof ANTLRHashString) && !(o instanceof String)) {
            return false;
        }
        ANTLRHashString s = o instanceof String ? new ANTLRHashString((String)o, this.lexer) : (ANTLRHashString)o;
        int l = this.length();
        if (s.length() != l) {
            return false;
        }
        if (this.lexer != null) {
            if (this.lexer.getCaseSensitiveLiterals()) {
                for (int i = 0; i < l; ++i) {
                    if (this.charAt(i) == s.charAt(i)) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < l; ++i) {
                    if (this.lexer.toLower(this.charAt(i)) == this.lexer.toLower(s.charAt(i))) continue;
                    return false;
                }
            }
        } else if (this.caseSensitiveLiterals) {
            for (int i = 0; i < l; ++i) {
                if (this.charAt(i) == s.charAt(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < l; ++i) {
                if (this.toLower(this.charAt(i)) == this.toLower(s.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private char toLower(char c) {
        return Character.toLowerCase(c);
    }

    public int hashCode() {
        if (this.hashCode == -1 || this.lexer != null) {
            int hashval = 0;
            int l = this.length();
            if (this.lexer != null) {
                if (this.lexer.getCaseSensitiveLiterals()) {
                    for (int i = 0; i < l; ++i) {
                        hashval = hashval * 151 + this.charAt(i);
                    }
                } else {
                    for (int i = 0; i < l; ++i) {
                        hashval = hashval * 151 + this.lexer.toLower(this.charAt(i));
                    }
                }
            } else if (this.caseSensitiveLiterals) {
                for (int i = 0; i < l; ++i) {
                    hashval = hashval * 151 + this.charAt(i);
                }
            } else {
                for (int i = 0; i < l; ++i) {
                    hashval = hashval * 151 + this.toLower(this.charAt(i));
                }
            }
            this.hashCode = hashval;
        }
        return this.hashCode;
    }

    private final int length() {
        return this.s != null ? this.s.length() : this.len;
    }

    public void setBuffer(char[] buf, int length) {
        this.buf = buf;
        this.len = length;
        this.s = null;
    }

    public void setString(String s) {
        this.s = s;
        this.buf = null;
    }
}

