/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.output.CompileAnnotation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JavaOutputListenerProvider
implements OutputProcessor {
    private static final String[] JAVAGOALS = new String[]{"mojo-execute#compiler:compile", "mojo-execute#compiler:testCompile", "mojo-execute#takari-lifecycle-plugin:compile", "mojo-execute#takari-lifecycle-plugin:testCompile"};
    private final Pattern failPattern = Pattern.compile("\\s*(?:\\[(WARNING|ERROR)\\])?(?:\\[javac\\])?(?:Compilation failure)?\\s*(?<clazz>.*)\\.java\\:\\[(?<linenr>[0-9]*),([0-9]*)\\] (?<text>.*)", 32);
    private String windowsDrive;
    private static final String GROUP_CLAZZ_NAME = "clazz";
    private static final String GROUP_LINE_NR = "linenr";
    private static final String GROUP_TEXT = "text";
    private static final String GROUP_DRIVE_NAME = "drive";
    private static final Pattern windowsDriveInfoPattern = Pattern.compile("(?:\\[INFO\\] )?Compiling \\d+ source files? to (?<drive>[A-Za-z]:)\\\\.+");

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        Matcher match = this.failPattern.matcher(line);
        if (match.matches()) {
            Sources srcs;
            Project prj;
            String clazz = match.group(GROUP_CLAZZ_NAME);
            String lineNum = match.group(GROUP_LINE_NR);
            String text = match.group(GROUP_TEXT);
            File clazzfile = clazz.startsWith("\\") && !clazz.startsWith("\\\\") && this.windowsDrive != null ? FileUtil.normalizeFile((File)new File(this.windowsDrive + clazz + ".java")) : FileUtil.normalizeFile((File)new File(clazz + ".java"));
            visitor.setOutputListener(new CompileAnnotation(clazzfile, lineNum, text), text.indexOf("[deprecation]") < 0);
            FileUtil.refreshFor((File[])new File[]{clazzfile});
            FileObject file = FileUtil.toFileObject((File)clazzfile);
            String newclazz = clazz;
            if (file != null && (prj = FileOwnerQuery.getOwner((FileObject)file)) != null && (srcs = (Sources)prj.getLookup().lookup(Sources.class)) != null) {
                for (SourceGroup grp : srcs.getSourceGroups("java")) {
                    if (!FileUtil.isParentOf((FileObject)grp.getRootFolder(), (FileObject)file) || !(newclazz = FileUtil.getRelativePath((FileObject)grp.getRootFolder(), (FileObject)file)).endsWith(".java")) continue;
                    newclazz = newclazz.substring(0, newclazz.length() - ".java".length());
                }
            }
            line = line.replace(clazz, newclazz);
            visitor.setLine(line);
        }
        if ((match = windowsDriveInfoPattern.matcher(line)).matches()) {
            this.windowsDrive = match.group(GROUP_DRIVE_NAME);
        }
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return JAVAGOALS;
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }
}

