/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ResEnvRefPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ResEnvRefTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class ResEnvRefsTablePanel
extends DefaultTablePanel {
    private ResEnvRefTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;

    public ResEnvRefsTablePanel(final DDDataObject dObj, final ResEnvRefTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.dObj = dObj;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dObj.modelUpdatedFromUI();
                dObj.setChangedFromUI(true);
                int row = ResEnvRefsTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
                dObj.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(WebApp webApp, ResourceEnvRef[] params) {
        this.model.setData((CommonDDBean)webApp, (CommonDDBean[])params);
        this.webApp = webApp;
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final int row = this.add ? -1 : ResEnvRefsTablePanel.this.getTable().getSelectedRow();
            final ResEnvRefPanel dialogPanel = new ResEnvRefPanel();
            if (!this.add) {
                ResourceEnvRef resRef = ResEnvRefsTablePanel.this.model.getResourceEnvRef(row);
                dialogPanel.setResEnvRefName(resRef.getResourceEnvRefName());
                dialogPanel.setResEnvRefType(resRef.getResourceEnvRefType());
                dialogPanel.setDescription(resRef.getDefaultDescription());
            }
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(ResEnvRefsTablePanel.class, (String)"TTL_ResourceEnvRef"), this.add){

                protected String validate() {
                    String name = dialogPanel.getResEnvRefName().trim();
                    String type = dialogPanel.getResEnvRefType().trim();
                    if (name.length() == 0) {
                        return NbBundle.getMessage(ResEnvRefsTablePanel.class, (String)"TXT_EmptyResRefName");
                    }
                    ResourceEnvRef[] params = ResEnvRefsTablePanel.this.webApp.getResourceEnvRef();
                    boolean exists = false;
                    for (int i = 0; i < params.length; ++i) {
                        if (row == i || !name.equals(params[i].getResourceEnvRefName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        return NbBundle.getMessage(ResEnvRefsTablePanel.class, (String)"TXT_ResRefNameExists", (Object)name);
                    }
                    if (type.length() == 0) {
                        return NbBundle.getMessage(ResEnvRefsTablePanel.class, (String)"TXT_EmptyResTypeValue");
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getTypeTF().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getTypeTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                ResEnvRefsTablePanel.this.dObj.modelUpdatedFromUI();
                ResEnvRefsTablePanel.this.dObj.setChangedFromUI(true);
                String name = dialogPanel.getResEnvRefName().trim();
                String type = dialogPanel.getResEnvRefType().trim();
                String description = dialogPanel.getDescription();
                if (this.add) {
                    ResEnvRefsTablePanel.this.model.addRow(new String[]{name, type, description});
                } else {
                    ResEnvRefsTablePanel.this.model.editRow(row, new String[]{name, type, description});
                }
                ResEnvRefsTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

