/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.type;

public abstract class SmallVectorImpl<T>
implements Native.assignable<SmallVectorImpl<T>>,
Native.NativeComparable<SmallVectorImpl<T>>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<T>,
Native.NativeIterable<iterator> {
    protected final T defaultValue;
    private T[] array;
    private static final Object[] EMPTY = new Object[0];
    private int end;

    public final T[] $array() {
        return this.array;
    }

    protected SmallVectorImpl(int capacity, T defaultValue) {
        this.array = capacity == 0 ? EMPTY : new Object[capacity];
        this.end = 0;
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + defaultValue;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImpl(int capacity, int initialSize, T defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImpl(int capacity, int initialSize, T value, T defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImpl(T[] array2, T defaultValue) {
        this.array = array2;
        int n = this.end = array2 == null ? 0 : array2.length;
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + defaultValue;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImpl(int capacity, type.iterator<?, T> iter, int length, T defaultValue) {
        this(capacity, iter, (type.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImpl(int capacity, type.iterator<?, T> begin, type.iterator<?, T> end, T defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImpl(SmallVectorImpl<T> other) {
        this.defaultValue = other.defaultValue;
        this.array = (Object[])other.array.clone();
        this.end = other.end;
    }

    protected SmallVectorImpl(JavaDifferentiators.JD.Move _dparam, SmallVectorImpl<T> other) {
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = null;
        other.end = 0;
    }

    public final SmallVectorImpl<T> $assign(SmallVectorImpl<T> other) {
        this.array = other.array;
        this.end = other.end;
        return this;
    }

    public final SmallVectorImpl<T> $assignMove(SmallVectorImpl<T> other) {
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = null;
        other.end = 0;
        return this;
    }

    public final void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, T defaultValue) {
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, T Elt) {
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign(type.iterator<?, T> __first, type.iterator<?, T> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public final void swap(SmallVectorImpl<T> RHS) {
        T[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(Object elem) {
        return this.find(elem, 0);
    }

    public final int find(Object elem, int from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq(this.array[i], (Object)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(Object elem) {
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(Object elem) {
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy((Object[])this.array, (int)(index + 1), (int)(this.end - index), (Object[])this.array, (int)index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy(I.$add(1), (type.iterator)this.end(), (type.iterator)I);
        this.pop_back();
        return N;
    }

    public final iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = (iterator)std.copy((type.iterator)E, (type.iterator)this.end(), (type.iterator)S);
        this.destroy_range(I, (iterator)this.end());
        this.setEnd(I);
        return N;
    }

    public final iterator insert(iterator I, T Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return ((iterator)this.end()).$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = ((iterator)this.begin()).$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, ((iterator)this.end()).$sub(1), (type.iterator)this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public final iterator insert(iterator I, int NumToInsert, T Elt) {
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return ((iterator)this.begin()).$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = ((iterator)this.begin()).$add(InsertElt);
        if (((iterator)this.end()).$sub(I) >= NumToInsert) {
            Object OldEnd = this.end();
            this.append(((iterator)this.end()).$sub(NumToInsert), (type.iterator<?, T>)this.end());
            std.copy_backward(I, ((iterator)OldEnd).$sub(NumToInsert), (type.iterator)OldEnd);
            std.fill_n(I, (int)NumToInsert, Elt);
            return I;
        }
        Object OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = ((iterator)OldEnd).$sub(I);
        std.copy(I, (type.iterator)OldEnd, ((iterator)this.end()).$sub(NumOverwritten));
        std.fill_n(I, (int)NumOverwritten, Elt);
        std.fill_n((type.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), Elt);
        return I;
    }

    public final iterator insert(iterator I, type.iterator<?, T> From, type.iterator<?, T> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return ((iterator)this.begin()).$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = ((iterator)this.begin()).$add(InsertElt);
        if (((iterator)this.end()).$sub(I) >= NumToInsert) {
            Object OldEnd = this.end();
            this.append(((iterator)this.end()).$sub(NumToInsert), (type.iterator<?, T>)this.end());
            std.copy_backward(I, ((iterator)OldEnd).$sub(NumToInsert), (type.iterator)OldEnd);
            std.copy(From, To, I);
            return I;
        }
        Object OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy(I, (type.iterator)OldEnd, ((iterator)this.end()).$sub(NumOverwritten));
        Object J = I.clone();
        for (NumOverwritten = ((iterator)OldEnd).$sub(I); NumOverwritten > 0; --NumOverwritten) {
            ((iterator)J).star$ref().$set(From.$star());
            ((iterator)J).$preInc();
            From.$preInc();
        }
        std.copy(From, To, (type.iterator)OldEnd);
        return I;
    }

    public final void append(type.iterator<?, T> in_start, type.iterator<?, T> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(T[] a) {
        this.append(a, 0, a.length);
    }

    public final void append(T[] a, int fromIndex, int count) {
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            T el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, T Elt) {
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final boolean $eq(SmallVectorImpl<T> RHS) {
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq(this.array[i], RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImpl<T> RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImpl)obj).begin(), (Object)((SmallVectorImpl)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((SmallVectorImpl)obj);
    }

    public final type.ref<T> ref$at(int idx) {
        return NativePointer.create_type$ref((Object[])this.array, (int)idx);
    }

    public final T $at(int idx) {
        return this.array[idx];
    }

    public final T $set(int idx, T value) {
        this.array[idx] = this.defaultValue == null ? value : Native.$tryAssign(this.array[idx], value, (boolean)this.isDataPointerLike());
        return value;
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
    }

    public final void push_back(T val) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(T val) {
        this.push_back(val);
    }

    public final void emplace_back() {
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final T pop_back_val() {
        T val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator<T> begin() {
        return new iterator(this, 0, false);
    }

    public final iterator<T> end() {
        return new iterator(this, this.end, false);
    }

    public final std.reverse_iterator<T> rbegin() {
        return new std.reverse_iterator((type.iterator)NativePointer.create_type$ptr((Object[])this.array, (int)this.end));
    }

    public final std.reverse_iterator<T> rend() {
        return new std.reverse_iterator((type.iterator)NativePointer.create_type$ptr((Object[])this.array));
    }

    public final type.ptr<T> data() {
        return NativePointer.create_type$ptr((Object[])this.array);
    }

    public final T front() {
        return this.array[0];
    }

    public final T back() {
        return this.array[this.end - 1];
    }

    public final type.ref<T> ref$front() {
        return new type.ref<T>(){
            private final T stored;
            private final int index = 0;
            {
                this.stored = SmallVectorImpl.this.array[0];
                this.index = 0;
            }

            public T $deref() {
                return this.stored;
            }

            public T $set(T value) {
                if (this.stored instanceof Native.assignable) {
                    ((Native.assignable)this.stored).$assign(value);
                } else {
                    ((SmallVectorImpl)SmallVectorImpl.this).array[0] = Native.$tryClone(value);
                }
                return value;
            }

            public type.ptr<T> deref$ptr() {
                return (type.ptr)SmallVectorImpl.this.data().$add(0);
            }
        };
    }

    public final type.ref<T> ref$back() {
        return new type.ref<T>(){
            private final T stored;
            private final int index;
            {
                this.stored = SmallVectorImpl.this.array[SmallVectorImpl.this.end - 1];
                this.index = SmallVectorImpl.this.end - 1;
            }

            public T $deref() {
                return this.stored;
            }

            public T $set(T value) {
                if (this.stored instanceof Native.assignable) {
                    ((Native.assignable)this.stored).$assign(value);
                } else {
                    ((SmallVectorImpl)SmallVectorImpl.this).array[this.index] = Native.$tryClone(value);
                }
                return value;
            }

            public type.ptr<T> deref$ptr() {
                return (type.ptr)SmallVectorImpl.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final int $sizeof() {
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (T elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final type.ptr<T> ptr$at(int idx) {
        return NativePointer.create_type$ptr((Object[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (this.defaultValue == null) {
                this.array[i] = null;
                continue;
            }
            Native.destroy(this.array[i]);
        }
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int capacity) {
        Object[] oldArray = this.array;
        this.array = new Object[capacity];
        NativePointer.copy$Object((Object[])oldArray, (int)0, (Object[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    public iterator<T> $toIterator(type.ptr<T> ptr2) {
        assert (ptr2.$array() == this.array);
        return new iterator(this, ptr2.$index(), false);
    }

    @Override
    public Iterator<T> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImpl{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            T element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImpl}\n");
        return out.toString();
    }

    private static final class JavaIterator<T>
    implements Iterator<T> {
        private final iterator<T> begin;
        private final iterator<T> end;

        public JavaIterator(iterator<T> begin, iterator<T> end) {
            this.begin = (iterator)Native.$tryClone(begin);
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.begin.$noteq(this.end);
        }

        @Override
        public T next() {
            T val = this.begin.$star();
            this.begin.$preInc();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static final class iterator<T>
    implements type.iterator<iterator<T>, T>,
    Native.assignable<iterator<T>>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final SmallVectorImpl<T> delegate;
        private int index;

        private iterator(SmallVectorImpl<T> delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator<T> $assign(iterator<T> other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public T $arrow() {
            return this.$at(0);
        }

        public T $star() {
            return this.$at(0);
        }

        public type.ref<T> star$ref() {
            return this.ref$at(0);
        }

        public int $sub(iterator<T> iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        public iterator<T> $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        public iterator<T> $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        public iterator<T> $postInc() {
            assert (!this._const);
            iterator<T> cloned = new iterator<T>(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        public iterator<T> $postDec() {
            assert (!this._const);
            iterator<T> cloned = new iterator<T>(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        public iterator<T> $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        public iterator<T> $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        public iterator<T> $add(int amount) {
            return new iterator<T>(this.delegate, this.index + amount, false);
        }

        public iterator<T> $sub(int amount) {
            return new iterator<T>(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        public iterator<T> clone() {
            return new iterator<T>(this.delegate, this.index, false);
        }

        public iterator<T> const_clone() {
            return new iterator<T>(this.delegate, this.index, true);
        }

        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public T $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public type.ref<T> ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public type.ptr<T> toPointer() {
            return NativePointer.create_type$ptr((Object[])((SmallVectorImpl)this.delegate).array, (int)this.index);
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

