/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.option.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.aliases.StringMapConstIteratorChar;
import org.llvm.adt.aliases.StringMapIteratorChar;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.option.Option;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public final class OptTableStatics {
    public static boolean isInput(StringSet Prefixes, StringRef Arg2) {
        if (llvm.$eq_StringRef((StringRef)Arg2, (StringRef)StringRef.R$MINUS)) {
            return true;
        }
        StringMapIteratorChar I = (StringMapIteratorChar)Native.$tryClone((NativeCloneable)Prefixes.begin());
        StringMapIteratorChar E = (StringMapIteratorChar)Native.$tryClone((NativeCloneable)Prefixes.end());
        while (I.$noteq((StringMapConstIteratorChar)E)) {
            if (Arg2.startswith(I.$arrow().getKey())) {
                return false;
            }
            I.$preInc();
        }
        return true;
    }

    public static int matchOption(type.ptr<OptTable.Info> I, StringRef Str, boolean IgnoreCase) {
        type.ptr Pre = (type.ptr)Native.$tryClone(((OptTable.Info)I.$star()).Prefixes);
        while (Pre.$star() != null) {
            StringRef Prefix = new StringRef((char.ptr)Pre.$star());
            if (Str.startswith(Prefix)) {
                boolean Matched;
                StringRef Rest = Str.substr(Prefix.size());
                boolean bl = Matched = IgnoreCase ? Rest.startswith_lower(new StringRef(((OptTable.Info)I.$star()).Name)) : Rest.startswith(((OptTable.Info)I.$star()).Name);
                if (Matched) {
                    return Prefix.size() + std.strlen((char.ptr)((OptTable.Info)I.$star()).Name);
                }
            }
            Pre.$preInc();
        }
        return 0;
    }

    public static std.string getOptionHelpName(OptTable Opts, OptSpecifier Id) {
        Option O = Opts.getOption(Id);
        std.string Name = O.getPrefixedName();
        switch (O.getKind()) {
            case 0: 
            case 1: 
            case 2: {
                throw new llvm_unreachable("Invalid option with help text.");
            }
            case 9: {
                char.ptr MetaVarName = Native.$tryClone((char.ptr)Opts.getOptionMetaVar(Id));
                if (MetaVarName != null) {
                    Name.$addassign((byte)32);
                    Name.$addassign(MetaVarName);
                    break;
                }
                int i = 0;
                int e = O.getNumArgs();
                while (Unsigned.$less_uint((int)i, (int)e)) {
                    Name.$addassign((CharSequence)" <value>");
                    ++i;
                }
                break;
            }
            case 3: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                Name.$addassign((byte)32);
            }
            case 4: 
            case 8: 
            case 11: {
                char.ptr MetaVarName = Native.$tryClone((char.ptr)Opts.getOptionMetaVar(Id));
                if (MetaVarName != null) {
                    Name.$addassign(MetaVarName);
                    break;
                }
                Name.$addassign((CharSequence)"<value>");
            }
        }
        return Name;
    }

    public static void PrintHelpOptionList(raw_ostream OS, StringRef Title, std.vector<std_pair.pair<std.string, char.ptr>> OptionHelp) {
        OS.$out(Title).$out(":\n");
        int OptionFieldWidth = 0;
        int e = OptionHelp.size();
        for (int i = 0; i != e; ++i) {
            int Length;
            if (((std_pair.pair)OptionHelp.$at((int)i)).second == null || (Length = ((std.string)((std_pair.pair)OptionHelp.$at((int)i)).first).size()) > 23) continue;
            OptionFieldWidth = std.max((int)OptionFieldWidth, (int)Length);
        }
        int InitialPad = 2;
        int e2 = OptionHelp.size();
        for (int i = 0; i != e2; ++i) {
            std.string Option2 = (std.string)((std_pair.pair)OptionHelp.$at((int)i)).first;
            int Pad = OptionFieldWidth - Option2.size();
            OS.indent(InitialPad).$out(Option2);
            if (Pad < 0) {
                OS.$out(NativePointer.$LF);
                Pad = OptionFieldWidth + InitialPad;
            }
            OS.indent(Pad + 1).$out((char.ptr)((std_pair.pair)OptionHelp.$at((int)i)).second).$out_char((byte)10);
        }
    }

    public static char.ptr getOptionHelpGroup(OptTable Opts, OptSpecifier Id) {
        int GroupID = Opts.getOptionGroupID(Id);
        if (GroupID == 0) {
            return NativePointer.$((String)"OPTIONS");
        }
        char.ptr GroupHelp = Native.$tryClone((char.ptr)Opts.getOptionHelpText(new OptSpecifier(GroupID)));
        if (GroupHelp != null) {
            return GroupHelp;
        }
        return OptTableStatics.getOptionHelpGroup(Opts, new OptSpecifier(GroupID));
    }
}

