/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public final class IncorrectMixedGroupUseHintError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.IncorrectMixedGroupUseHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getErrors());
        }
    }

    private static final class IncorrectMixedGroupUse
    extends VerificationError {
        private static final String KEY = "Php.Group.Use.Mixed";

        IncorrectMixedGroupUse(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.IncorrectMixedGroupUse_displayName();
        }

        public String getDescription() {
            return Bundle.IncorrectMixedGroupUse_description();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;
        private UseStatement currentUseStatement;
        private GroupUseStatementPart currentGroupUseStatementPart;

        CheckVisitor(FileObject fileObject) {
            assert (fileObject != null);
            this.fileObject = fileObject;
        }

        List<VerificationError> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        @Override
        public void visit(UseStatement statement) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.currentUseStatement = statement;
            super.visit(statement);
            this.currentUseStatement = null;
        }

        @Override
        public void visit(GroupUseStatementPart statementPart) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.currentGroupUseStatementPart = statementPart;
            super.visit(statementPart);
            this.currentGroupUseStatementPart = null;
        }

        @Override
        public void visit(SingleUseStatementPart statementPart) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkSingleUseStatement(statementPart);
            super.visit(statementPart);
        }

        private void checkSingleUseStatement(SingleUseStatementPart statementPart) {
            if (this.currentUseStatement == null || this.currentGroupUseStatementPart == null) {
                return;
            }
            UseStatement.Type type = statementPart.getType();
            if (type == null) {
                return;
            }
            if (this.currentUseStatement.getType() != UseStatement.Type.TYPE) {
                this.createError(statementPart);
            }
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new IncorrectMixedGroupUse(this.fileObject, startOffset, endOffset));
        }
    }
}

