/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.commit;

import java.util.ArrayList;
import java.util.Set;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public final class ExcludeFromCommitAction
extends ContextAction {
    public static final int UNDEFINED = -1;
    public static final int EXCLUDING = 1;
    public static final int INCLUDING = 2;

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        if (!HgUtils.isFromHgRepository(context) || ctxFiles == null || ctxFiles.size() == 0) {
            return false;
        }
        return !HgUtils.onlyProjects(nodes) && !HgUtils.onlyFolders(ctxFiles);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        int actionStatus = this.getActionStatus(ctx);
        switch (actionStatus) {
            case -1: 
            case 1: {
                return "CTL_MenuItem_ExcludeFromCommit";
            }
            case 2: {
                return "CTL_MenuItem_IncludeInCommit";
            }
        }
        throw new RuntimeException("Invalid action status: " + actionStatus);
    }

    public int getActionStatus(VCSContext ctx) {
        HgModuleConfig config = HgModuleConfig.getDefault(HgUtils.getRootFile(ctx));
        int status = -1;
        if (ctx == null) {
            ctx = HgUtils.getCurrentContext(null);
        }
        Set files = ctx.getRootFiles();
        for (VCSFileProxy file : files) {
            if (config.isExcludedFromCommit(file.getPath())) {
                if (status == 1) {
                    return -1;
                }
                status = 2;
                continue;
            }
            if (status == 2) {
                return -1;
            }
            status = 1;
        }
        return status;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext ctx = HgUtils.getCurrentContext(nodes);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor();
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                HgModuleConfig config = HgModuleConfig.getDefault(HgUtils.getRootFile(ctx));
                int status = ExcludeFromCommitAction.this.getActionStatus(ctx);
                Set files = ctx.getRootFiles();
                ArrayList<String> paths = new ArrayList<String>(files.size());
                for (VCSFileProxy file : files) {
                    paths.add(file.getPath());
                }
                if (this.isCanceled()) {
                    return;
                }
                if (status != 2) {
                    config.addExclusionPaths(paths);
                } else {
                    config.removeExclusionPaths(paths);
                }
            }
        };
        support.start(rp, HgUtils.getRootFile(ctx), "");
    }
}

