/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitMergeResult;
import org.netbeans.modules.git.remote.cli.GitRepository;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.CommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class MergeCommand
extends GitCommand {
    private final String revision;
    private GitMergeResult result;
    private String commitMessage;
    private final GitRepository.FastForwardOption ffOption;
    private final ProgressMonitor monitor;

    public MergeCommand(JGitRepository repository, GitClassFactory gitFactory, String revision, GitRepository.FastForwardOption ffOption, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.ffOption = ffOption;
        this.revision = revision;
        this.monitor = monitor;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "merge");
        if (this.ffOption != null) {
            this.addArgument(0, this.ffOption.toString());
        }
        this.addArgument(0, this.revision);
        this.addArgument(1, "log");
        this.addArgument(1, "--raw");
        this.addArgument(1, "--pretty=raw");
        this.addArgument(1, "-1");
    }

    public GitMergeResult getResult() {
        return this.result;
    }

    void setCommitMessage(String message) {
        if (message != null) {
            message = message.replace("\n", "").replace("\r", "");
        }
        this.commitMessage = message;
    }

    @Override
    protected void run() throws GitException {
        block6: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final GitMergeResult.MergeResultContainer merge = new GitMergeResult.MergeResultContainer();
                merge.mergeStatus = GitMergeResult.MergeStatus.NOT_SUPPORTED;
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        MergeCommand.this.parseMergeOutput(output, merge);
                    }

                    @Override
                    protected void outputErrorParser(String output, String error, int exitCode) throws GitException {
                        MergeCommand.this.parseMergeOutput(output, merge);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        MergeCommand.this.parseMergeError(error, merge);
                    }
                }.runCLI();
                if (merge.mergeStatus == GitMergeResult.MergeStatus.MERGED) {
                    final GitRevisionInfo.GitRevCommit status = new GitRevisionInfo.GitRevCommit();
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            CommitCommand.parseLog(output, status);
                        }
                    }.runCLI();
                    merge.mergedCommits = status.parents.toArray(new String[status.parents.size()]);
                }
                if (canceled.canceled()) {
                    return;
                }
                this.result = this.getClassFactory().createMergeResult(merge, this.getRepository().getLocation());
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block6;
                throw new GitException(t);
            }
        }
    }

    private void parseMergeOutput(String output, GitMergeResult.MergeResultContainer merge) {
        for (String line : output.split("\n")) {
            if (line.startsWith("Updating ")) {
                String s = line.substring(9).trim();
                int i = s.indexOf("..");
                if (i <= 0) continue;
                merge.base = s.substring(0, i);
                merge.newHead = s.substring(i + 2);
                continue;
            }
            if (line.startsWith(" ")) {
                int i = line.indexOf(124);
                if (i <= 0) continue;
                String string = line.substring(1, i).trim();
                continue;
            }
            if (line.startsWith("Already up-to-date")) {
                merge.mergeStatus = GitMergeResult.MergeStatus.ALREADY_UP_TO_DATE;
                continue;
            }
            if (line.startsWith("Fast-forward")) {
                merge.mergeStatus = GitMergeResult.MergeStatus.FAST_FORWARD;
                continue;
            }
            if (line.startsWith("Auto-merging")) {
                merge.mergeStatus = GitMergeResult.MergeStatus.MERGED;
                continue;
            }
            if (line.startsWith("Merge")) {
                merge.mergeStatus = GitMergeResult.MergeStatus.MERGED;
                continue;
            }
            if (line.startsWith("Abort")) {
                merge.mergeStatus = GitMergeResult.MergeStatus.ABORTED;
                continue;
            }
            if (line.startsWith("Fail")) {
                merge.mergeStatus = GitMergeResult.MergeStatus.FAILED;
                continue;
            }
            if (line.startsWith("Conflict")) {
                merge.mergeStatus = GitMergeResult.MergeStatus.CONFLICTING;
                continue;
            }
            if (!line.startsWith("CONFLICT")) continue;
            merge.mergeStatus = GitMergeResult.MergeStatus.CONFLICTING;
        }
    }

    private void parseMergeError(String output, GitMergeResult.MergeResultContainer merge) {
        for (String line : output.split("\n")) {
            if (line.startsWith("\t")) {
                String file = line.substring(1).trim();
                continue;
            }
            if (line.startsWith("Abort")) {
                merge.mergeStatus = GitMergeResult.MergeStatus.ABORTED;
                continue;
            }
            if (!line.startsWith("fatal:") || !line.contains("aborting")) continue;
            merge.mergeStatus = GitMergeResult.MergeStatus.ABORTED;
        }
    }
}

