/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitRebaseResult {
    private final RebaseStatus rebaseStatus;
    private final List<VCSFileProxy> conflicts;
    private final List<VCSFileProxy> failures;
    private final String currentHead;
    private final String currentCommit;

    GitRebaseResult(RebaseResultContainer rebaseResult) {
        this.rebaseStatus = rebaseResult.rebaseStatus;
        this.conflicts = rebaseResult.conflicts;
        this.failures = rebaseResult.failures;
        this.currentHead = rebaseResult.currentHead;
        this.currentCommit = rebaseResult.currentCommit;
    }

    public RebaseStatus getRebaseStatus() {
        return this.rebaseStatus;
    }

    public String getCurrentHead() {
        return this.currentHead;
    }

    public String getCurrentCommit() {
        return this.currentCommit;
    }

    public Collection<VCSFileProxy> getConflicts() {
        return this.conflicts;
    }

    public Collection<VCSFileProxy> getFailures() {
        return this.failures;
    }

    public static final class RebaseResultContainer {
        public RebaseStatus rebaseStatus;
        public final List<VCSFileProxy> conflicts = new ArrayList<VCSFileProxy>();
        public final List<VCSFileProxy> failures = new ArrayList<VCSFileProxy>();
        public String currentHead;
        public String currentCommit;
    }

    public static enum RebaseStatus {
        OK{

            @Override
            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        ABORTED{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        STOPPED{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        FAILED{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        CONFLICTS{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        UP_TO_DATE{

            @Override
            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        FAST_FORWARD{

            @Override
            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        NOTHING_TO_COMMIT{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        };


        public abstract boolean isSuccessful();
    }
}

