/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryList;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.SftpTransport;
import org.netbeans.modules.remote.impl.fs.server.FSSTransport;
import org.netbeans.modules.remote.spi.FileSystemProvider;

public abstract class RemoteFileSystemTransport {
    public static Warmup createWarmup(ExecutionEnvironment execEnv, String path) {
        return RemoteFileSystemTransport.getInstanceFast(execEnv).createWarmup(path);
    }

    public static boolean needsClientSidePollingRefresh(ExecutionEnvironment execEnv) {
        return RemoteFileSystemTransport.getInstanceFast(execEnv).needsClientSidePollingRefresh();
    }

    public static boolean canRefreshFast(ExecutionEnvironment execEnv) {
        return RemoteFileSystemTransport.getInstanceFast(execEnv).canRefreshFast();
    }

    public static boolean canSetAccessCheckType(ExecutionEnvironment execEnv) {
        return RemoteFileSystemTransport.getInstanceFast(execEnv).canSetAccessCheckType();
    }

    public static void setAccessCheckType(ExecutionEnvironment execEnv, FileSystemProvider.AccessCheckType accessCheckType) {
        RemoteFileSystemTransport.getInstanceFast(execEnv).setAccessCheckType(accessCheckType);
    }

    static FileSystemProvider.AccessCheckType getAccessCheckType(ExecutionEnvironment execEnv) {
        return RemoteFileSystemTransport.getInstanceFast(execEnv).getAccessCheckType();
    }

    public static void refreshFast(RemoteDirectory directory, boolean expected) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        RemoteFileSystem fs;
        if (!directory.hasCache()) {
            return;
        }
        String path = directory.getPath();
        if (path.isEmpty()) {
            path = "/";
        }
        long time = 0L;
        int foCount = 0;
        int syncCount = 0;
        if (RemoteLogger.getInstance().isLoggable(Level.FINE)) {
            fs = directory.getFileSystem();
            time = System.currentTimeMillis();
            foCount = fs.getCachedFileObjectsCount();
            syncCount = fs.getDirSyncCount();
        }
        RemoteFileSystemTransport.getInstanceSlow(directory.getExecutionEnvironment()).refreshFast(path, expected);
        if (RemoteLogger.getInstance().isLoggable(Level.FINE)) {
            fs = directory.getFileSystem();
            time = System.currentTimeMillis() - time;
            foCount = fs.getCachedFileObjectsCount() - foCount;
            syncCount = fs.getDirSyncCount() - syncCount;
            RemoteLogger.fine("Fast refresh {0} [{1} fo, {2} syncs, {3} new fo] took {4} ms", directory.getDisplayName(), fs.getCachedFileObjectsCount(), syncCount, foCount, time);
        }
    }

    public static void scheduleRefresh(ExecutionEnvironment env, Collection<String> paths) {
        RemoteFileSystemTransport.getInstanceFast(env).scheduleRefresh(paths);
    }

    static void onFocusGained(ExecutionEnvironment execEnv) {
        RemoteFileSystemTransport.getInstanceFast(execEnv).onFocusGained();
    }

    static void onConnect(ExecutionEnvironment execEnv) {
        RemoteFileSystemTransport.getInstanceFast(execEnv).onConnect();
    }

    public static void registerDirectory(RemoteDirectory directory) {
        RemoteFileSystemTransport.getInstanceFast(directory.getExecutionEnvironment()).registerDirectoryImpl(directory);
    }

    public static void unregisterDirectory(ExecutionEnvironment execEnv, String path) {
        RemoteFileSystemTransport.getInstanceFast(execEnv).unregisterDirectoryImpl(path);
    }

    public static DirEntryList readDirectory(ExecutionEnvironment execEnv, String path) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirEntryList entries;
        block5: {
            entries = null;
            FSSTransport transport = FSSTransport.getInstance(execEnv);
            if (transport != null && ((RemoteFileSystemTransport)transport).isValidFast()) {
                try {
                    entries = ((RemoteFileSystemTransport)transport).readDirectory(path);
                }
                catch (IOException | ExecutionException ex) {
                    if (!((RemoteFileSystemTransport)transport).isValidFast()) break block5;
                    throw ex;
                }
            }
        }
        if (entries == null) {
            if (RemoteFileSystemUtils.isUnitTestMode()) {
                throw new ExecutionException("Can not get valid transport for " + execEnv, null);
            }
            SftpTransport directoryReader = SftpTransport.getInstance(execEnv);
            entries = ((RemoteFileSystemTransport)directoryReader).readDirectory(path);
        }
        return entries;
    }

    public static DirEntry stat(ExecutionEnvironment execEnv, String path) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        return RemoteFileSystemTransport.getInstanceSlow(execEnv).stat(path);
    }

    public static DirEntry stat(ExecutionEnvironment execEnv, String path, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        return RemoteFileSystemTransport.getInstanceSlow(execEnv).stat(path, timeoutMillis);
    }

    public static DirEntry lstat(ExecutionEnvironment execEnv, String path) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        return RemoteFileSystemTransport.getInstanceSlow(execEnv).lstat(path);
    }

    public static DirEntry lstat(ExecutionEnvironment execEnv, String path, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        return RemoteFileSystemTransport.getInstanceSlow(execEnv).lstat(path, timeoutMillis);
    }

    public static DirEntryList delete(ExecutionEnvironment execEnv, String path, boolean directory) throws ConnectException, IOException {
        try {
            return RemoteFileSystemTransport.getInstanceSlow(execEnv).delete(path, directory);
        }
        catch (InterruptedException | CancellationException ex) {
            InterruptedIOException ioe = new InterruptedIOException(ex.getMessage());
            ioe.initCause(ex);
            throw ioe;
        }
        catch (TimeoutException ex) {
            throw new IOException(ex);
        }
    }

    public static boolean canCopy(ExecutionEnvironment execEnv, String from, String to) {
        return RemoteFileSystemTransport.getInstanceFast(execEnv).canCopy(from, to);
    }

    public static DirEntryList copy(ExecutionEnvironment execEnv, String from, String to, Collection<IOException> subdirectoryExceptions) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        return RemoteFileSystemTransport.getInstanceSlow(execEnv).copy(from, to, subdirectoryExceptions);
    }

    public static boolean canMove(ExecutionEnvironment execEnv, String from, String to) {
        return RemoteFileSystemTransport.getInstanceFast(execEnv).canMove(from, to);
    }

    public static MoveInfo move(ExecutionEnvironment execEnv, String from, String to) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        return RemoteFileSystemTransport.getInstanceSlow(execEnv).move(from, to);
    }

    public static DirEntry uploadAndRename(ExecutionEnvironment execEnv, File src, String pathToUpload, String pathToRename) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException, InterruptedException {
        return RemoteFileSystemTransport.getInstanceSlow(execEnv).uploadAndRename(src, pathToUpload, pathToRename);
    }

    private static RemoteFileSystemTransport getInstanceFast(ExecutionEnvironment execEnv) {
        RemoteFileSystemTransport transport = FSSTransport.getInstance(execEnv);
        if (transport == null || !((RemoteFileSystemTransport)transport).isValidFast()) {
            transport = SftpTransport.getInstance(execEnv);
        }
        return transport;
    }

    private static RemoteFileSystemTransport getInstanceSlow(ExecutionEnvironment execEnv) throws ConnectException, InterruptedException, CancellationException {
        RemoteFileSystemTransport transport = FSSTransport.getInstance(execEnv);
        if (transport == null || !((RemoteFileSystemTransport)transport).isValidSlow()) {
            transport = SftpTransport.getInstance(execEnv);
        }
        return transport;
    }

    protected abstract boolean canCopy(String var1, String var2);

    protected abstract DirEntryList copy(String var1, String var2, Collection<IOException> var3) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    protected abstract boolean canMove(String var1, String var2);

    protected abstract MoveInfo move(String var1, String var2) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    protected abstract DirEntry stat(String var1) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    protected abstract DirEntry stat(String var1, int var2) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    protected abstract DirEntry lstat(String var1) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    protected abstract DirEntry lstat(String var1, int var2) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    protected abstract DirEntryList readDirectory(String var1) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    protected abstract boolean isValidFast();

    protected abstract boolean isValidSlow() throws ConnectException, InterruptedException, CancellationException;

    protected abstract boolean needsClientSidePollingRefresh();

    protected abstract boolean canRefreshFast();

    protected abstract void refreshFast(String var1, boolean var2) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    protected abstract void registerDirectoryImpl(RemoteDirectory var1);

    protected abstract void unregisterDirectoryImpl(String var1);

    protected abstract void scheduleRefresh(Collection<String> var1);

    protected abstract DirEntry uploadAndRename(File var1, String var2, String var3) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException, InterruptedException;

    protected abstract boolean canSetAccessCheckType();

    protected abstract void setAccessCheckType(FileSystemProvider.AccessCheckType var1);

    protected abstract FileSystemProvider.AccessCheckType getAccessCheckType();

    protected abstract DirEntryList delete(String var1, boolean var2) throws TimeoutException, ConnectException, IOException;

    protected void onConnect() {
    }

    protected void onFocusGained() {
    }

    protected Warmup createWarmup(String path) {
        return null;
    }

    public static class MoveInfo {
        public final DirEntryList from;
        public final DirEntryList to;

        public MoveInfo(DirEntryList src, DirEntryList dst) {
            this.from = src;
            this.to = dst;
        }
    }

    public static interface Warmup {
        public DirEntryList getAndRemove(String var1) throws InterruptedException;

        public void remove(String var1);

        public DirEntryList tryGetAndRemove(String var1);
    }
}

