/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.ui.browser.WaitNode;
import org.netbeans.modules.subversion.ui.search.SvnSearch;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryPathNode
extends AbstractNode {
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private RepositoryPathEntry entry;
    private final BrowserClient client;
    private boolean repositoryFolder;
    private boolean isListed = false;
    static final String PROPERTY_NAME_REVISION = "revision";
    static final String PROPERTY_NAME_DATE = "date";
    static final String PROPERTY_NAME_AUTHOR = "author";
    static final String PROPERTY_NAME_HISTORY = "history";
    private static final String HISTORY_DISPLAY_NAME = NbBundle.getMessage(RepositoryPathNode.class, (String)"LBL_BrowserTree_History_Name");
    private static final String HISTORY_SHORT_DESC = NbBundle.getMessage(RepositoryPathNode.class, (String)"LBL_BrowserTree_History_Short_Desc");

    static RepositoryPathNode createRepositoryPathNode(BrowserClient client, RepositoryFile file) {
        return RepositoryPathNode.createRepositoryPathNode(client, new RepositoryPathEntry(file, SVNNodeKind.DIR, new SVNRevision(0), null, ""));
    }

    static RepositoryPathNode createRepositoryPathNode(BrowserClient client, RepositoryPathEntry entry) {
        RepositoryPathNode node = new RepositoryPathNode(client, entry, true);
        return node;
    }

    static RepositoryPathNode createPreselectedPathNode(BrowserClient client, RepositoryFile file) {
        return RepositoryPathNode.createDelayedExpandNode(client, file);
    }

    static RepositoryPathNode createRepositoryRootNode(BrowserClient client, RepositoryFile file) {
        return RepositoryPathNode.createDelayedExpandNode(client, file);
    }

    private static RepositoryPathNode createDelayedExpandNode(BrowserClient client, RepositoryFile file) {
        return new DelayedExpandNode(client, new RepositoryPathEntry(file, SVNNodeKind.DIR, new SVNRevision(0), null, ""), true);
    }

    private RepositoryPathNode(BrowserClient client, RepositoryPathEntry entry, boolean repositoryFolder) {
        super((Children)(entry.getSvnNodeKind() == SVNNodeKind.DIR ? new RepositoryPathChildren(client) : Children.LEAF));
        this.entry = entry;
        this.client = client;
        this.repositoryFolder = repositoryFolder;
        this.initProperties();
    }

    public Image getIcon(int type) {
        if (this.entry.getSvnNodeKind() == SVNNodeKind.DIR) {
            return this.getTreeFolderIcon(false);
        }
        return super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        if (this.entry.getSvnNodeKind() == SVNNodeKind.DIR) {
            return this.getTreeFolderIcon(true);
        }
        return super.getOpenedIcon(type);
    }

    private Image getTreeFolderIcon(boolean opened) {
        Image base;
        Icon baseIcon = UIManager.getIcon(opened ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
        if (baseIcon != null) {
            base = ImageUtilities.icon2Image((Icon)baseIcon);
        } else {
            base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
            if (base == null) {
                base = ImageUtilities.loadImage((String)"org/openide/loaders/defaultFolder.gif");
            }
        }
        assert (base != null);
        return base;
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new RevisionProperty());
        ps.put((Node.Property)new DateProperty());
        ps.put((Node.Property)new AuthorProperty());
        ps.put((Node.Property)new HistoryProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        if (this.entry.getRepositoryFile().isRepositoryRoot()) {
            return SvnUtils.decodeToString(this.entry.getRepositoryFile().getRepositoryUrl());
        }
        return this.entry.getRepositoryFile().getName();
    }

    public void setName(String name) {
        String oldName = this.getName();
        if (!oldName.equals(name)) {
            this.renameNode(this, name, 0);
            this.fireNameChange(oldName, name);
        }
    }

    private void renameNode(RepositoryPathNode node, String newParentsName, int level) {
        node.entry = new RepositoryPathEntry(node.entry.getRepositoryFile().replaceLastSegment(newParentsName, level), node.entry.getSvnNodeKind(), node.entry.getLastChangedRevision(), node.entry.getLastChangedDate(), node.entry.getLastChangedAuthor());
        Children childern = node.getChildren();
        Node[] childernNodes = childern.getNodes();
        ++level;
        for (Node childernNode : childernNodes) {
            if (!(childernNode instanceof RepositoryPathNode)) continue;
            this.renameNode((RepositoryPathNode)childernNode, newParentsName, level);
        }
    }

    public Action[] getActions(boolean context) {
        return this.client.getActions();
    }

    RepositoryPathEntry getEntry() {
        return this.entry;
    }

    public BrowserClient getClient() {
        return this.client;
    }

    public boolean canRename() {
        return !this.repositoryFolder;
    }

    private void setRepositoryFolder(boolean bl) {
        this.repositoryFolder = bl;
    }

    void expand() {
        if (this.isListed) {
            return;
        }
        this.isListed = true;
        Children ch = this.getChildren();
        if (ch instanceof RepositoryPathChildren) {
            ((RepositoryPathChildren)this.getChildren()).listRepositoryPath(this.entry);
        }
    }

    private static class RevisionPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public RevisionPropertyEditor(Object value) {
            this.setValue(value);
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
            renderer.setForeground(gfx.getColor());
            Object val = this.getValue();
            if (val instanceof Date) {
                val = DateFormat.getDateTimeInstance().format((Date)val);
            }
            renderer.setText(val == null ? "" : val.toString());
            renderer.setBounds(box);
            renderer.paint(gfx);
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private static class DelayedExpandNode
    extends RepositoryPathNode {
        private final int IGNORE_EXPANDS = 0;
        private int expanded = 0;

        public DelayedExpandNode(BrowserClient client, RepositoryPathEntry entry, boolean repositoryFolder) {
            super(client, entry, repositoryFolder);
        }

        @Override
        void expand() {
            try {
                if (this.expanded < 0) {
                    return;
                }
                super.expand();
            }
            finally {
                if (this.expanded <= 0) {
                    ++this.expanded;
                }
            }
        }
    }

    public static class RepositoryPathEntry {
        private final SVNNodeKind svnNodeKind;
        private final RepositoryFile file;
        private final SVNRevision revision;
        private final Date date;
        private final String author;

        RepositoryPathEntry(RepositoryFile file, SVNNodeKind svnNodeKind, SVNRevision revision, Date date, String author) {
            this.svnNodeKind = svnNodeKind;
            this.file = file;
            this.revision = revision;
            this.date = date;
            this.author = author;
        }

        public SVNNodeKind getSvnNodeKind() {
            return this.svnNodeKind;
        }

        RepositoryFile getRepositoryFile() {
            return this.file;
        }

        SVNRevision getLastChangedRevision() {
            return this.revision;
        }

        Date getLastChangedDate() {
            return this.date;
        }

        String getLastChangedAuthor() {
            return this.author != null ? this.author : "";
        }
    }

    private class HistoryPropertyEditor
    extends PropertyEditorSupport {
        public HistoryPropertyEditor() {
            this.setValue("");
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            SVNRevision revision = RepositoryPathNode.this.entry.getLastChangedRevision();
            SVNUrl repositoryUrl = RepositoryPathNode.this.entry.getRepositoryFile().getRepositoryUrl();
            SVNUrl fileUrl = RepositoryPathNode.this.entry.getRepositoryFile().getFileUrl();
            SvnSearch svnSearch = new SvnSearch(new RepositoryFile(repositoryUrl, fileUrl, revision));
            return svnSearch.getSearchPanel();
        }
    }

    private abstract class NodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected NodeProperty(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                Object obj = this.getValue();
                if (obj instanceof Date) {
                    obj = DateFormat.getDateTimeInstance().format((Date)obj);
                }
                return obj != null ? obj.toString() : "";
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.INFO, null, e);
                return e.getLocalizedMessage();
            }
        }

        public boolean canWrite() {
            return false;
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new RevisionPropertyEditor(this.getValue());
            }
            catch (Exception e) {
                return new PropertyEditorSupport();
            }
        }
    }

    private class HistoryProperty
    extends PropertySupport.ReadOnly<String> {
        public HistoryProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_HISTORY, String.class, HISTORY_DISPLAY_NAME, HISTORY_SHORT_DESC);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return "";
        }

        public String toString() {
            try {
                String obj = this.getValue();
                return obj != null ? obj.toString() : "";
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.INFO, null, e);
                return e.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            return new HistoryPropertyEditor();
        }
    }

    private class AuthorProperty
    extends NodeProperty<String> {
        public AuthorProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_AUTHOR, String.class, RepositoryPathNode.PROPERTY_NAME_AUTHOR, RepositoryPathNode.PROPERTY_NAME_AUTHOR);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return RepositoryPathNode.this.entry.getLastChangedAuthor();
        }
    }

    private class DateProperty
    extends NodeProperty<Object> {
        public DateProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_DATE, Object.class, RepositoryPathNode.PROPERTY_NAME_DATE, RepositoryPathNode.PROPERTY_NAME_DATE);
        }

        public Object getValue() {
            Date date = RepositoryPathNode.this.entry.getLastChangedDate();
            return date == null ? "" : date;
        }
    }

    private class RevisionProperty
    extends NodeProperty<Object> {
        public RevisionProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_REVISION, Object.class, RepositoryPathNode.PROPERTY_NAME_REVISION, RepositoryPathNode.PROPERTY_NAME_REVISION);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            SVNRevision r = RepositoryPathNode.this.entry.getLastChangedRevision();
            if (r instanceof SVNRevision.Number) {
                return ((SVNRevision.Number)r).getNumber();
            }
            if (r == null) {
                return "";
            }
            return r.toString();
        }
    }

    private static class RepositoryPathChildren
    extends Children.Keys {
        private final BrowserClient client;
        private Node[] previousNodes = null;

        public RepositoryPathChildren(BrowserClient client) {
            this.client = client;
        }

        protected void addNotify() {
            super.addNotify();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node) {
                return new Node[]{(Node)key};
            }
            RepositoryPathEntry entry = (RepositoryPathEntry)key;
            if (this.previousNodes != null) {
                for (Node n : this.previousNodes) {
                    if (!(n instanceof RepositoryPathNode) || !((RepositoryPathNode)n).entry.getRepositoryFile().getName().equals(entry.getRepositoryFile().getName())) continue;
                    return null;
                }
            }
            RepositoryPathNode pathNode = RepositoryPathNode.createRepositoryPathNode(this.client, entry);
            return new Node[]{pathNode};
        }

        public void listRepositoryPath(final RepositoryPathEntry pathEntry) {
            this.previousNodes = this.getNodes();
            WaitNode waitNode = new WaitNode(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2001"));
            this.setKeys(Collections.singleton(waitNode));
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(pathEntry.getRepositoryFile().getRepositoryUrl());
            SvnProgressSupport support = new SvnProgressSupport(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform() {
                    try {
                        List<RepositoryPathEntry> listedEntries = RepositoryPathChildren.this.client.listRepositoryPath(pathEntry, this);
                        if (this.isCanceled()) {
                            return;
                        }
                        Collection previousEntries = RepositoryPathChildren.this.getPreviousNodeEntries();
                        ArrayList<RepositoryPathEntry> accepptedNewEntries = new ArrayList<RepositoryPathEntry>();
                        if (listedEntries == null) {
                            RepositoryPathNode node = (RepositoryPathNode)RepositoryPathChildren.this.getNode();
                            node.setRepositoryFolder(false);
                        } else {
                            if (!RepositoryPathChildren.this.isCreativeBrowser(RepositoryPathChildren.this.client)) {
                                RepositoryPathChildren.this.removePreselectedFolders(listedEntries, false);
                            }
                            ArrayList<RepositoryPathEntry> deletedEntries = new ArrayList<RepositoryPathEntry>();
                            for (RepositoryPathEntry listedEntry : listedEntries) {
                                boolean found = false;
                                for (RepositoryPathEntry previousEntry : previousEntries) {
                                    if (!previousEntry.getRepositoryFile().getName().equals(listedEntry.getRepositoryFile().getName())) continue;
                                    if (!listedEntry.getSvnNodeKind().equals((Object)previousEntry.getSvnNodeKind())) {
                                        deletedEntries.add(listedEntry);
                                        break;
                                    }
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                accepptedNewEntries.add(listedEntry);
                            }
                            RepositoryPathChildren.this.removePreselectedFolders(deletedEntries, true);
                        }
                        RepositoryPathChildren.access$702(RepositoryPathChildren.this, null);
                        RepositoryPathChildren.this.setKeys(accepptedNewEntries);
                    }
                    catch (SVNClientException ex) {
                        Collection entries = RepositoryPathChildren.this.getPreviousNodeEntries();
                        if (entries.isEmpty()) {
                            RepositoryPathChildren.this.setKeys(Collections.singleton(RepositoryPathChildren.errorNode((Exception)((Object)ex))));
                        }
                    }
                    finally {
                        RepositoryPathChildren.access$702(RepositoryPathChildren.this, null);
                    }
                }
            };
            support.start(rp, pathEntry.getRepositoryFile().getRepositoryUrl(), NbBundle.getMessage(Browser.class, (String)"BK2001"));
            Node parentNode = this.getNode().getParentNode();
            if (parentNode != null) {
                ((RepositoryPathNode)parentNode).expand();
            }
        }

        private Collection<RepositoryPathEntry> getPreviousNodeEntries() {
            ArrayList<RepositoryPathEntry> l = new ArrayList<RepositoryPathEntry>();
            if (this.previousNodes != null) {
                for (Node node : this.previousNodes) {
                    if (!(node instanceof RepositoryPathNode)) continue;
                    l.add(((RepositoryPathNode)node).entry);
                }
            }
            return l;
        }

        private String getLastPathSegment(RepositoryPathEntry entry) {
            String[] childSegments = entry.getRepositoryFile().getPathSegments();
            return childSegments.length > 0 ? childSegments[childSegments.length - 1] : null;
        }

        private static Node errorNode(Exception ex) {
            AbstractNode errorNode = new AbstractNode(Children.LEAF);
            errorNode.setDisplayName(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2002"));
            errorNode.setShortDescription(ex.getLocalizedMessage());
            return errorNode;
        }

        private boolean isCreativeBrowser(BrowserClient client) {
            Action[] actions;
            for (Action action : actions = client.getActions()) {
                if (!(action instanceof CreateFolderAction)) continue;
                return true;
            }
            return false;
        }

        private void removePreselectedFolders(Collection cl, boolean removeContained) {
            Node[] childNodes = this.getNodes();
            for (int i = 0; i < childNodes.length; ++i) {
                String lastChildSegment;
                if (!(childNodes[i] instanceof RepositoryPathNode) || (lastChildSegment = this.getLastPathSegment(((RepositoryPathNode)childNodes[i]).getEntry())) == null) continue;
                boolean pathExists = false;
                Iterator it = cl.iterator();
                while (it.hasNext()) {
                    String lastNewChildSegment = this.getLastPathSegment((RepositoryPathEntry)it.next());
                    if (lastNewChildSegment == null || !lastNewChildSegment.equals(lastChildSegment)) continue;
                    pathExists = true;
                    break;
                }
                if (pathExists != removeContained) continue;
                this.remove(new Node[]{childNodes[i]});
            }
        }

        static /* synthetic */ Node[] access$702(RepositoryPathChildren x0, Node[] x1) {
            x0.previousNodes = x1;
            return x1;
        }
    }
}

