/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.makefile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.makefile.MakefileApiAccessorImpl;
import org.netbeans.modules.cnd.api.makefile.MakefileElement;
import org.netbeans.modules.cnd.makefile.MakefileApiAccessor;
import org.netbeans.modules.cnd.makefile.parser.MakefileParseResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public class MakefileSupport {
    private MakefileSupport() {
    }

    public static List<MakefileElement> parseFile(FileObject fileObject) throws ParseException {
        Source source = Source.create((FileObject)fileObject);
        if (source == null) {
            new IllegalArgumentException("Valid file expected, got " + fileObject).printStackTrace(System.err);
            return Collections.emptyList();
        }
        return MakefileSupport.parse(source);
    }

    public static List<MakefileElement> parseDocument(Document doc) throws ParseException {
        Source source = Source.create((Document)doc);
        if (source == null) {
            throw new IllegalArgumentException("Valid document expected, got " + doc);
        }
        return MakefileSupport.parse(source);
    }

    private static List<MakefileElement> parse(Source source) throws ParseException {
        if (!"text/x-make".equals(source.getMimeType())) {
            throw new IllegalArgumentException("Makefile source expected, got " + source);
        }
        ArrayList<MakefileElement> result = new ArrayList<MakefileElement>(1);
        ParseTask task = new ParseTask(result);
        ParserManager.parse(Collections.singleton(source), (UserTask)task);
        return result;
    }

    static {
        MakefileApiAccessor.setInstance(new MakefileApiAccessorImpl());
    }

    private static final class ParseTask
    extends UserTask {
        private final List<MakefileElement> elements;

        public ParseTask(List<MakefileElement> elements) {
            this.elements = elements;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Parser.Result result = resultIterator.getParserResult();
            if (result instanceof MakefileParseResult) {
                MakefileParseResult makefileResult = (MakefileParseResult)result;
                this.elements.addAll(makefileResult.getElements());
            }
        }
    }
}

