/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java.jni.actions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.mixeddev.MixedDevUtils;
import org.netbeans.modules.cnd.mixeddev.Triple;
import org.netbeans.modules.cnd.mixeddev.java.JNISupport;
import org.netbeans.modules.cnd.mixeddev.java.jni.actions.AbstractJNIAction;
import org.netbeans.modules.cnd.mixeddev.java.jni.ui.JProjectFileChooser;
import org.netbeans.modules.cnd.mixeddev.java.model.jni.JNIClass;
import org.netbeans.modules.cnd.mixeddev.wizard.Generator;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MutableObject;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectPlatform;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.windows.WindowManager;

public class GenerateHeaderForJNIClassAction
extends AbstractJNIAction {
    public GenerateHeaderForJNIClassAction(Lookup context) {
        super(context);
        this.putValue("Name", NbBundle.getMessage(MixedDevUtils.class, (String)"cnd.mixeddev.generate_header_for_jni_class"));
    }

    @Override
    protected boolean isEnabledAtPosition(Document doc, int caret) {
        return JNISupport.isJNIClass(doc, caret);
    }

    @Override
    protected void actionPerformedImpl(Node[] activatedNodes) {
        Triple<DataObject, Document, Integer> context = this.extractContext(activatedNodes);
        if (context != null) {
            FileObject javaFile = ((DataObject)context.first).getPrimaryFile();
            Document doc = (Document)context.second;
            int caret = (Integer)context.third;
            JNIClass cls = JNISupport.getJNIClass(doc, caret);
            assert (cls != null);
            String headerFileName = CharSequenceUtils.concatenate((CharSequence)cls.getClassInfo().getName(), (CharSequence)".h").toString();
            final List<NativeProject> nativeProjects = MixedDevUtils.toList(MixedDevUtils.findNativeProjects());
            FileObject toJump = null;
            for (NativeProject nativeProject : nativeProjects) {
                NativeFileSearch fileSearch = NativeProjectSupport.getNativeFileSearch((NativeProject)nativeProject);
                Collection searchResult = fileSearch.searchFile(nativeProject, headerFileName);
                if (searchResult == null || searchResult.isEmpty()) continue;
                if (searchResult.size() == 1) {
                    FSPath foundHeaderPath = (FSPath)searchResult.iterator().next();
                    toJump = this.generateHeader(javaFile, foundHeaderPath.getPath());
                    continue;
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MixedDevUtils.class, (String)"cnd.mixeddev.header_files_ambiguity", (Object)nativeProject.getProjectDisplayName(), (Object)headerFileName), 0));
            }
            if (toJump == null) {
                String headerPath;
                FileObject header;
                Project chosenProject = null;
                FileObject chosenFolder = null;
                try {
                    final MutableObject chosenProjectHolder = new MutableObject();
                    final MutableObject chosenFolderHolder = new MutableObject();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JProjectFileChooser chooser = new JProjectFileChooser(WindowManager.getDefault().getMainWindow(), true, nativeProjects);
                            chooser.setVisible(true);
                            chosenProjectHolder.value = chooser.getChosenProject();
                            chosenFolderHolder.value = chooser.getChosenFile();
                        }
                    });
                    chosenProject = (Project)chosenProjectHolder.value;
                    chosenFolder = (FileObject)chosenFolderHolder.value;
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (chosenProject != null && chosenFolder != null && (header = this.generateHeader(javaFile, headerPath = chosenFolder.getPath() + File.separator + headerFileName)) != null) {
                    String sourcePath = chosenFolder.getPath() + File.separator + header.getName() + ".cpp";
                    StringBuilder sourceContent = this.printSourceHeader(javaFile, header, new StringBuilder());
                    FileObject source = this.generateSource(javaFile, sourcePath, sourceContent.toString());
                    this.registerFilesInProject(chosenProject, Pair.of((Object)header, (Object)true), Pair.of((Object)source, (Object)false));
                    this.waitParse(chosenProject);
                    try {
                        Generator.createStub(header, source, sourceContent);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    this.waitParse(chosenProject);
                    toJump = source;
                }
            }
            if (toJump != null) {
                CsmUtilities.openSource(toJump, (int)0);
            }
        }
    }

    private void registerFilesInProject(Project proj, Pair<FileObject, Boolean> ... files) {
        if (files != null && files.length > 0) {
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)proj.getLookup().lookup(ConfigurationDescriptorProvider.class);
            pdp.getConfigurationDescriptor();
            if (pdp.gotDescriptor()) {
                MakeConfigurationDescriptor configurationDescriptor = pdp.getConfigurationDescriptor();
                for (Pair<FileObject, Boolean> pair : files) {
                    FileObject fileObject = (FileObject)pair.first();
                    boolean header = (Boolean)pair.second();
                    if (fileObject == null || !fileObject.isValid()) continue;
                    Folder logicFolder = header ? Generator.getRootHeader(configurationDescriptor) : Generator.getRootSource(configurationDescriptor);
                    Item item = Item.ItemFactory.getDefault().createInFileSystem(configurationDescriptor.getBaseDirFileSystem(), fileObject.getPath());
                    logicFolder.addItemAction(item);
                }
                configurationDescriptor.save();
            }
        }
    }

    private void waitParse(Project proj) {
        CsmModel model = CsmModelAccessor.getModel();
        CsmProject project = model.getProject((Object)proj);
        project.waitParse();
    }

    private FileObject generateHeader(FileObject javaFile, String headerPath) {
        ClassPath sourceCP = ClassPath.getClassPath((FileObject)javaFile, (String)"classpath/source");
        ClassPath compileCP = ClassPath.getClassPath((FileObject)javaFile, (String)"classpath/compile");
        FileObject sr = sourceCP != null ? sourceCP.findOwnerRoot(javaFile) : null;
        Project javaProject = FileOwnerQuery.getOwner((FileObject)sr);
        J2SEProjectPlatform pp = (J2SEProjectPlatform)javaProject.getLookup().lookup(J2SEProjectPlatform.class);
        JavaPlatform jp = pp.getProjectPlatform();
        FileObject binFO = jp.findTool("javah");
        return JNISupport.generateJNIHeader(binFO, sr, javaFile, headerPath, sourceCP, compileCP);
    }

    private FileObject generateSource(FileObject javaFile, String sourcePath, String content) {
        File file = new File(sourcePath);
        try (FileWriter w = new FileWriter(file);){
            w.write(content);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return FileUtil.toFileObject((File)file);
    }

    private StringBuilder printSourceHeader(FileObject javaFile, FileObject header, StringBuilder sb) {
        sb.append("// Native methods implementation of\n// ").append(javaFile.getPath()).append("\n\n");
        sb.append("#include \"").append(header.getNameExt()).append("\"\n");
        return sb;
    }

    private Pair<CsmScope, CsmScope> getCppFunctionScopes(CsmOffsetable symbol) {
        CsmFunction declaration = null;
        CsmFunctionDefinition definition = null;
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)symbol)) {
            declaration = (CsmFunction)symbol;
            definition = declaration.getDefinition();
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)symbol)) {
            definition = (CsmFunctionDefinition)symbol;
            declaration = definition.getDeclaration();
        }
        CsmScope declScope = null;
        if (declaration != null && !CsmKindUtilities.isNamespaceDefinition((CsmObject)(declScope = declaration.getScope()))) {
            declScope = declaration.getContainingFile();
        }
        CsmScope defScope = null;
        if (definition != null && !CsmKindUtilities.isNamespaceDefinition((CsmObject)(defScope = definition.getScope()))) {
            defScope = definition.getContainingFile();
        }
        if (declScope != null || defScope != null) {
            return Pair.of((Object)declScope, (Object)defScope);
        }
        return null;
    }
}

