/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.preferences;

import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpunit.preferences.Bundle;
import org.netbeans.modules.php.phpunit.preferences.PhpUnitPreferences;
import org.netbeans.modules.php.phpunit.util.PhpUnitUtils;

public final class PhpUnitPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public PhpUnitPreferencesValidator validate(PhpModule phpModule) {
        this.validateBootstrap(PhpUnitPreferences.isBootstrapEnabled(phpModule), PhpUnitPreferences.getBootstrapPath(phpModule));
        this.validateConfiguration(PhpUnitPreferences.isConfigurationEnabled(phpModule), PhpUnitPreferences.getConfigurationPath(phpModule));
        this.validateCustomSuite(PhpUnitPreferences.isCustomSuiteEnabled(phpModule), PhpUnitPreferences.getCustomSuitePath(phpModule));
        this.validatePhpUnit(PhpUnitPreferences.isPhpUnitEnabled(phpModule), PhpUnitPreferences.getPhpUnitPath(phpModule));
        return this;
    }

    public PhpUnitPreferencesValidator validateBootstrap(boolean bootstrapEnabled, String bootstrapPath) {
        this.validatePath(bootstrapEnabled, bootstrapPath, Bundle.PhpUnitPreferencesValidator_bootstrap_label(), "bootstrapPath");
        return this;
    }

    public PhpUnitPreferencesValidator validateConfiguration(boolean configurationEnabled, String configurationPath) {
        this.validatePath(configurationEnabled, configurationPath, Bundle.PhpUnitPreferencesValidator_configuration_label(), "configurationPath");
        return this;
    }

    public PhpUnitPreferencesValidator validateCustomSuite(boolean customSuiteEnabled, String customSuitePath) {
        this.validatePath(customSuiteEnabled, customSuitePath, Bundle.PhpUnitPreferencesValidator_customSuite_label(), "customSuitePath");
        return this;
    }

    public PhpUnitPreferencesValidator validatePhpUnit(boolean phpUnitEnabled, String phpUnitPath) {
        String warning;
        if (phpUnitEnabled && (warning = PhpUnitUtils.validatePhpUnitPath(phpUnitPath)) != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"phpUnitPath", warning));
        }
        return this;
    }

    private void validatePath(boolean pathEnabled, String path, String label, String source) {
        if (!pathEnabled) {
            return;
        }
        String warning = FileUtils.validateFile((String)label, (String)path, (boolean)false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)source, warning));
        }
    }
}

