/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding.el;

import java.util.Hashtable;
import java.util.Vector;
import org.netbeans.microedition.databinding.el.Coercions;
import org.netbeans.microedition.databinding.el.Logger;

public class ELUtils {
    public static final int OPERATOR_EQUAL = 61;
    public static final int OPERATOR_NON_EQUAL = 33;
    public static final int OPERATOR_LT = 60;
    public static final int OPERATOR_GT = 62;
    public static final int OPERATOR_GE = 108;
    public static final int OPERATOR_LE = 103;
    public static final int OPERATOR_PLUS = 43;
    public static final int OPERATOR_MINUS = 45;
    public static final int OPERATOR_MULTIPLY = 42;
    public static final int OPERATOR_DIVIDE = 47;
    public static final int OPERATOR_MODULUS = 37;
    public static final int OPERATOR_UNARY_NOT = 33;
    public static final int OPERATOR_UNARY_MINUS = 45;
    public static final int OPERATOR_EMPTY = 32;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;

    public static boolean coerceToBoolean(Object object) {
        return Coercions.coerceObjectToBoolean(object, null);
    }

    public static boolean applyEqualityOperator(Object value1, Object value2, int operator) {
        switch (operator) {
            case 33: 
            case 61: {
                return Coercions.applyEqualityOperator(value1, value2, operator, null);
            }
        }
        throw new IllegalStateException();
    }

    public static boolean applyRelationalOperator(Object value1, Object value2, int operator) {
        switch (operator) {
            case 60: 
            case 62: {
                if (value1 == value2) {
                    return false;
                }
                if (value1 == null || value2 == null) {
                    return false;
                }
                return Coercions.applyRelationalOperator(value1, value2, operator, null);
            }
            case 103: 
            case 108: {
                if (value1 == value2) {
                    return true;
                }
                if (value1 == null || value2 == null) {
                    return false;
                }
                return Coercions.applyRelationalOperator(value1, value2, operator, null);
            }
        }
        throw new IllegalStateException();
    }

    public static Object applyArithmeticOperator(Object value1, Object value2, int operator) {
        switch (operator) {
            case 42: 
            case 43: 
            case 45: {
                return Coercions.applyArithmeticOperator(value1, value2, operator, null);
            }
            case 47: {
                return ELUtils.applyDivideOperator(value1, value2, null);
            }
            case 37: {
                return ELUtils.applyModuleOperator(value1, value2, null);
            }
        }
        throw new IllegalStateException();
    }

    private static Object applyModuleOperator(Object pLeft, Object pRight, Logger pLogger) {
        if (pLeft == null && pRight == null) {
            return new Integer(0);
        }
        if (pLeft != null && (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointString(pLeft)) || pRight != null && (Coercions.isFloatingPointType(pRight) || Coercions.isFloatingPointString(pRight))) {
            double left = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = ELUtils.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
            double right = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = ELUtils.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
            try {
                return new Double(left % right);
            }
            catch (Exception exc) {
                return new Integer(0);
            }
        }
        long left = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Long == null ? (class$java$lang$Long = ELUtils.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
        long right = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Long == null ? (class$java$lang$Long = ELUtils.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
        try {
            return new Long(left % right);
        }
        catch (Exception exc) {
            return new Integer(0);
        }
    }

    public static Object applyUnaryOperation(Object value, int operator) {
        switch (operator) {
            case 45: {
                return ELUtils.applyUnaryMinusOperator(value, null);
            }
            case 33: {
                return ELUtils.applyUnaryNotOperator(value, null);
            }
            case 32: {
                return ELUtils.applyEmptyOperator(value, null);
            }
        }
        throw new IllegalStateException();
    }

    private static Object applyUnaryNotOperator(Object pValue, Logger pLogger) {
        boolean val = Coercions.coerceObjectToBoolean(pValue, pLogger);
        return !val ? Boolean.TRUE : Boolean.FALSE;
    }

    private static Object applyEmptyOperator(Object pValue, Logger pLogger) {
        if (pValue == null) {
            return Boolean.TRUE;
        }
        if ("".equals(pValue)) {
            return Boolean.TRUE;
        }
        if (pValue.getClass().isArray() && ((Object[])pValue).length == 0) {
            return Boolean.TRUE;
        }
        if (pValue instanceof Vector && ((Vector)pValue).isEmpty()) {
            return Boolean.TRUE;
        }
        if (pValue instanceof Hashtable && ((Hashtable)pValue).isEmpty()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Object applyUnaryMinusOperator(Object pValue, Logger pLogger) {
        if (pValue == null) {
            return new Integer(0);
        }
        if (pValue instanceof String) {
            if (Coercions.isFloatingPointString(pValue)) {
                double dval = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pValue, class$java$lang$Double == null ? (class$java$lang$Double = ELUtils.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
                return new Double(-dval);
            }
            long lval = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pValue, class$java$lang$Long == null ? (class$java$lang$Long = ELUtils.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
            return new Long(-lval);
        }
        if (pValue instanceof Byte) {
            return new Byte(-((Byte)pValue).byteValue());
        }
        if (pValue instanceof Short) {
            return new Short(-((Short)pValue).shortValue());
        }
        if (pValue instanceof Integer) {
            return new Integer(-((Integer)pValue).intValue());
        }
        if (pValue instanceof Long) {
            return new Long(-((Long)pValue).longValue());
        }
        if (pValue instanceof Float) {
            return new Float(-((Float)pValue).floatValue());
        }
        if (pValue instanceof Double) {
            return new Double(-((Double)pValue).doubleValue());
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError("unaryOpBadType", pValue.getClass().getName());
        }
        return new Integer(0);
    }

    private static Object applyDivideOperator(Object pLeft, Object pRight, Logger pLogger) {
        if (pLeft == null && pRight == null) {
            return new Integer(0);
        }
        double left = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = ELUtils.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
        double right = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = ELUtils.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
        try {
            return new Double(left / right);
        }
        catch (Exception exc) {
            return new Integer(0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

