/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.netbeans.libs.git.GitClientCallback;

public class JGitCredentialsProvider
extends CredentialsProvider {
    private final GitClientCallback callback;
    private static final Logger LOG = Logger.getLogger(JGitCredentialsProvider.class.getName());

    public JGitCredentialsProvider(GitClientCallback callback) {
        this.callback = callback;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... credentialItems) {
        return true;
    }

    public boolean get(URIish uriish, CredentialItem ... items) throws UnsupportedCredentialItem {
        boolean retval = true;
        String uri = uriish.toString();
        for (CredentialItem item : items) {
            CredentialItem.Username credItem;
            if (item instanceof CredentialItem.Username) {
                credItem = (CredentialItem.Username)item;
                String username = this.callback.getUsername(uri, credItem.getPromptText());
                if (username == null) {
                    retval = false;
                    continue;
                }
                credItem.setValue(username);
                continue;
            }
            if (item instanceof CredentialItem.Password) {
                credItem = (CredentialItem.Password)item;
                char[] password = this.callback.getPassword(uri, credItem.getPromptText());
                if (password == null) {
                    retval = false;
                    continue;
                }
                credItem.setValue(password);
                continue;
            }
            if (item instanceof CredentialItem.InformationalMessage) {
                LOG.log(Level.FINE, "Informational message: {0} - {1}", new Object[]{uri, item.getPromptText()});
                continue;
            }
            if (item instanceof CredentialItem.YesNoType) {
                credItem = (CredentialItem.YesNoType)item;
                Boolean value = this.callback.askYesNoQuestion(uri, credItem.getPromptText());
                if (value == null) {
                    retval = false;
                    continue;
                }
                credItem.setValue(value.booleanValue());
                continue;
            }
            if (item instanceof CredentialItem.StringType) {
                char[] pwd;
                credItem = (CredentialItem.StringType)item;
                String answer = credItem instanceof IdentityFileItem ? this.callback.getIdentityFile(uri, credItem.getPromptText()) : (credItem.getPromptText().toLowerCase().contains("password for") ? ((pwd = this.callback.getPassword(uri, credItem.getPromptText())) == null ? null : new String(pwd)) : (credItem.getPromptText().toLowerCase().contains("passphrase for") ? ((pwd = this.callback.getPassphrase(uri, credItem.getPromptText())) == null ? null : new String(pwd)) : this.callback.askQuestion(uri, credItem.getPromptText())));
                if (answer == null) {
                    retval = false;
                    continue;
                }
                credItem.setValue(answer);
                continue;
            }
            LOG.log(Level.WARNING, "Unknown credential item: {0} - {1}:{2}", new Object[]{uri, item.getClass().getName(), item.getPromptText()});
        }
        return retval;
    }

    public static class IdentityFileItem
    extends CredentialItem.StringType {
        public IdentityFileItem(String promptText, boolean maskValue) {
            super(promptText, maskValue);
        }
    }
}

