/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.identicator;

import com.mchange.v1.identicator.IdHashKey;
import com.mchange.v1.identicator.Identicator;
import com.mchange.v1.identicator.StrongIdHashKey;
import com.mchange.v1.util.WrapperIterator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IdHashSet
extends AbstractSet
implements Set {
    HashSet inner;
    Identicator id;

    private IdHashSet(HashSet inner, Identicator id) {
        this.inner = inner;
        this.id = id;
    }

    public IdHashSet(Identicator id) {
        this(new HashSet(), id);
    }

    public IdHashSet(Collection c, Identicator id) {
        this(new HashSet(2 * c.size()), id);
    }

    public IdHashSet(int initialCapacity, float loadFactor, Identicator id) {
        this(new HashSet(initialCapacity, loadFactor), id);
    }

    public IdHashSet(int initialCapacity, Identicator id) {
        this(new HashSet(initialCapacity, 0.75f), id);
    }

    public Iterator iterator() {
        return new WrapperIterator(this.inner.iterator(), true){

            protected Object transformObject(Object o) {
                IdHashKey idKey = (IdHashKey)o;
                return idKey.getKeyObj();
            }
        };
    }

    public int size() {
        return this.inner.size();
    }

    public boolean contains(Object o) {
        return this.inner.contains(this.createKey(o));
    }

    public boolean add(Object o) {
        return this.inner.add(this.createKey(o));
    }

    public boolean remove(Object o) {
        return this.inner.remove(this.createKey(o));
    }

    public void clear() {
        this.inner.clear();
    }

    private IdHashKey createKey(Object o) {
        return new StrongIdHashKey(o, this.id);
    }
}

